<?php
/**
 * ImportBuddy Backup Importer Script
 *
 * ATTENTION: IF YOU ARE READING THIS WHILE TRYING TO LOAD IMPORTBUDDY TO RESTORE YOUR SITE:
 * Your server is not properly handling PHP files. Contact your hosting provider to fix this.
 * Notify them that PHP files are not executing and instead are outputting their code contents.
 *
 * @package BackupBuddy
 */

/**
 * <!-- ImportBuddy Restore & Migration Tool - iThemes.com
 *
 * @version 8.6.2.0 (downloaded 2023-07-03T10:42:39+00:00)
 * @author iThemes.com
 * @developer Dustin Bolton
 * @created Feb 11, 2010
 *
 * ###############################################################################################
 * #                                                                                             #
 * #  THERE ARE NO USER-EDITABLE PORTIONS OF THIS FILE! DO NOT EDIT UNLESS DIRECTED BY SUPPORT!  #
 * #                                                                                             #
 * ###############################################################################################
 */

define( 'PB_PASSWORD', 'dbcfa619e58ce477ce38f2df727bb6c8' ); // Update this portion with the hashed password to override a forgotten password.

$php_minimum         = '5.1'; // User's PHP must be equal or newer to this version.
$ignore_not_writable = false; // Set to true to ignore is_writable() returning false on this directory. Useful for servers lying about the writable status of the directory.

// Uncomment the following line when 500 Internal Server Error occurs.
// error_reporting( E_ALL );

if ( version_compare( PHP_VERSION, $php_minimum ) < 0 ) {
	die( 'ERROR #9013. See <a href="https://ithemeshelp.zendesk.com/hc/en-us/articles/211132377-Error-Codes-#9013">this page for details</a>. Sorry! PHP version ' . $php_minimum . ' or newer is required for BackupBuddy to properly run. You are running PHP version ' . PHP_VERSION . '.' );
}

global $importbuddy_file;
$importbuddy_file = basename( __FILE__ ); // filename of importbuddy.php (or whatever it is named).

global $wp_version;
$wp_version = '4.4'; // Spoof a version for new wp-db class.
$abspath    = rtrim( dirname( __FILE__ ), '\\/' ) . '/';

define( 'ABSPATH', $abspath );
define( 'WP_CONTENT_DIR', $abspath . 'wp-content' );
define( 'PB_BB_VERSION', '8.6.2.0 (downloaded 2023-07-03T10:42:39+00:00)' );
define( 'DB_CHARSET', 'utf8' ); // Default only. Overriden later if needed. Used by wpdb class.
define( 'DB_COLLATE', '' ); // Default only. Overriden alter if needed. Used by wpdb class.

@date_default_timezone_set( @date_default_timezone_get() ); // Prevents date() from throwing a warning if the default timezone has not been set. Run prior to any file_exists()!

/**
 * Checks the current step.
 *
 * @return int|false  Current step or false when step not found or invalid.
 */
function ib_directory_browsing_allowed() {
	if ( ! isset( $_GET['step'] ) ) {
		return false;
	}

	$step = $_GET['step'];

	if ( ! is_numeric( $step ) ) {
		return false;
	}

	if ( $step < 5 ) {
		return false;
	}

	return $step;
}

// Try to put an index.htm file in place during import to help prevent against file browsing. Only do if not a defined step OR a non-numeric defined step OR a defined numeric step < 5.
if ( ! ib_directory_browsing_allowed() ) {
	if ( ! file_exists( ABSPATH . 'index.htm' ) && ! file_exists( ABSPATH . 'index.php' ) ) {
		@file_put_contents( ABSPATH . 'index.htm', '<html></html>' );
	}
}

// If inside BB install then die. Else unpack importbuddy if needed.
if ( @file_exists( @dirname( @dirname( __FILE__ ) ) . '/backupbuddy.php' ) ) {
	die( '<html>Access Denied</html>' );
}


// Unpack importbuddy files into importbuddy directory. Does this when importbuddy directory does not exist OR if now request GET or POST params are sent (aka the first page only).
if ( ! file_exists( ABSPATH . 'importbuddy' ) || ( ( count( $_GET ) == 0 ) && ( count( $_POST ) == 0 ) ) ) {

	$importbuddy_contents = file_get_contents( __FILE__ );
	if ( false === $importbuddy_contents ) {
		die( 'Error #8494834: Unable to read in importbuddy file `' . __FILE__ . '` for validating.' );
	}

	// Make sure this file is complete and contains all the packed data to the end before proceeding.
	if ( false === strpos( $importbuddy_contents, '###PACKDATA' . ',END' ) ) { // Concat here so we don't false positive on this line when searching.
		die( 'ERROR: It appears your `' . __FILE__ . '` file is incomplete.  It may have not finished downloading or uploading completely.  Please try re-downloading the script from within BackupBuddy in WordPress (do not just copy the file from the plugin directory) and re-uploading it.' );
	}

	// Make sure no leading whitespace. Some servers introduce this to the beginning, breaking authentication due to output before auth headers being sent.
	if ( ltrim( $importbuddy_contents ) !== $importbuddy_contents ) {
		if ( false === ( file_put_contents( __FILE__, ltrim( $importbuddy_contents ) ) ) ) {
			die( 'Error #84394834: Your importbuddy file `' . __FILE__ . '` file contains leading whitespace/newslines and the script could not re-write it to fix it for you (possibly due to permissions). Please re-download it or manually edit to make sure it begins with <?php with no spaces or newlines/enters before it.' );
		} else { // Re-wrote file.
			sleep( 1 );
			die( '<meta http-equiv="refresh" content="1">Refreshing... Removed unexpected leading whitespace found in importbuddy.php file.' );
		}
	}

	$importbuddy_contents = '';

	$unpack_importbuddy = true;
	if ( file_exists( ABSPATH . 'importbuddy' ) ) { // ImportBuddy directory already exists. We may need to re-unpack it if this file has been updated since.
		$signature = @file_get_contents( ABSPATH . 'importbuddy/_signature.php' );
		$signature = trim( str_replace( '<?php die(); ?>', '', $signature ) );
		if ( md5( PB_BB_VERSION . PB_PASSWORD ) != $signature ) { // Signature mismatch. We will need to delete and unpack again to update.
			// echo '<!-- unlinking existing importbuddy directory. -->'; 5.1.0.10: Broke causing headers already sent error due to auth.
			recursive_unlink( ABSPATH . 'importbuddy' );
		} else {
			$unpack_importbuddy = false;
		}
	}
	if ( true === $unpack_importbuddy ) {
		unpack_importbuddy( $ignore_not_writable );
		@file_put_contents( ABSPATH . 'importbuddy/_signature.php', '<?php die(); ?>' . md5( PB_BB_VERSION . PB_PASSWORD ) ); // Create a hash of this ImportBuddy version & password. On accessing importbuddy.php's authentication page all importbuddy files will be freshly unpacked if the importbuddy.php version and/or password mismatches to allow users to just replace importbuddy.php to upgrade ImportBuddy or password.
	}
}

// Database wrapper.
require_once ABSPATH . 'importbuddy/classes/wp-db.php';
global $wpdb;

if ( isset( $_GET['api'] ) && '' != $_GET['api'] ) { // API ACCESS.
	if ( 'ping' === $_GET['api'] ) {
		die( 'pong' );
	} else {
		die( 'Unknown API access action.' );
	}
} else { // NORMAL ACCESS.
	if ( ! file_exists( ABSPATH . 'importbuddy/init.php' ) ) {
		die( 'Error: Unable to find file `' . ABSPATH . 'importbuddy/init.php`. Make sure that you downloaded this script from within BackupBuddy. Copying importbuddy files from inside the plugin directory is not sufficient as many file additions are made on demand.' );
	} else {
		require_once ABSPATH . 'importbuddy/init.php';
	}
}

/**
 * Recursively delete files.
 *
 * @param string $path  Path to start deleting.
 *
 * @return bool  If successful.
 */
function recursive_unlink( $path ) {
	return is_file( $path ) ? @unlink( $path ) : array_map( 'recursive_unlink', glob( $path . '/*' ) ) == @rmdir( $path );
}

/**
 * Unpacks required files encoded in importbuddy.php into stand-alone files.
 *
 * @param bool $ignore_not_writable  Ignore not writeable errors.
 */
function unpack_importbuddy( $ignore_not_writable = false ) {
	if ( ! is_writable( ABSPATH ) && false === $ignore_not_writable ) {
		echo 'Error #224834. This directory, `' . ABSPATH . '`, is not write enabled according to the server. Please verify proper write permissions to continue. If this persists, contact your web hosting provider and tell them that is_writable("' . ABSPATH . '") returns FALSE in PHP.';
		die();
	} else {
		$unpack_file = '';

		$handle = @fopen( __FILE__, 'r' );
		if ( $handle ) {
			while ( ( $buffer = fgets( $handle ) ) !== false ) {
				if ( substr( $buffer, 0, 11 ) == '###PACKDATA' ) {
					$packdata_commands = explode( ',', trim( $buffer ) );
					array_shift( $packdata_commands );

					if ( 'BEGIN' === $packdata_commands[0] ) {
						// Start packed data.
					} elseif ( 'FILE_START' === $packdata_commands[0] ) {
						$unpack_file = $packdata_commands[2];
					} elseif ( 'FILE_END' === $packdata_commands[0] ) {
						$unpack_file = '';
					} elseif ( 'END' === $packdata_commands[0] ) {
						return;
					}
				} else {
					if ( '' != $unpack_file ) {
						if ( ! is_dir( dirname( ABSPATH . $unpack_file ) ) ) {
							$mkdir_result = mkdir( dirname( ABSPATH . $unpack_file ), 0777, true ); // second param makes recursive.
							if ( false === $mkdir_result ) {
								echo 'Error #54455. Unable to mkdir `' . dirname( ABSPATH . $unpack_file ) . '`<br>';
							}
						}
						$fileput_result = file_put_contents( ABSPATH . $unpack_file, base64_decode( $buffer ) );
						if ( false === $fileput_result ) {
							echo 'Error #65656. Unable to put file contents to `' . ABSPATH . $unpack_file . '`.<br>';
						}
					}
				}
			}
			if ( ! feof( $handle ) ) {
				echo 'Error: unexpected fgets() fail.<br>';
			}
			fclose( $handle );
		} else {
			echo 'ERROR #54455: Unable to open `' . __FILE__ . '` file for reading in packaged data.<br>';
		}
	}
}

die();

/*
###PACKDATA,BEGIN
###PACKDATA,FILE_START,/_importbuddy/importbuddy/.htaccess,importbuddy/.htaccess

###PACKDATA,FILE_END,/_importbuddy/importbuddy/.htaccess,importbuddy/.htaccess
###PACKDATA,FILE_START,/_importbuddy/importbuddy/importbuddy-hooks.php,importbuddy/importbuddy-hooks.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/importbuddy-hooks.php,importbuddy/importbuddy-hooks.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/index.htm,importbuddy/index.htm
PGh0bWw+PC9odG1sPg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/index.htm,importbuddy/index.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/index.html,importbuddy/index.html
PGh0bWw+PC9odG1sPg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/index.html,importbuddy/index.html
###PACKDATA,FILE_START,/_importbuddy/importbuddy/index.php,importbuddy/index.php
PD9waHAKLyoqCiAqIFNpbGVuY2UgaXMgZ29sZGVuLgogKgogKiBAcGFja2FnZSBCYWNrdXBCdWRkeQogKi8K
###PACKDATA,FILE_END,/_importbuddy/importbuddy/index.php,importbuddy/index.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/init.php,importbuddy/init.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/init.php,importbuddy/init.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/init_admin.php,importbuddy/init_admin.php
PD9waHAKcGJfYmFja3VwYnVkZHk6OmxvYWQoKTsKCi8vICoqKioqKioqKiogQUNUSU9OUyAoYWRtaW4pICoqKioqKioqKioKCgoKLy8gKioqKioqKioqKiBBSkFYIChhZG1pbikgKioqKioqKioqKgoKCgovLyAqKioqKioqKioqIERBU0hCT0FSRCAoYWRtaW4pICoqKioqKioqKioKCgoKLy8gKioqKioqKioqKiBGSUxURVJTIChhZG1pbikgKioqKioqKioqKgoKCgovLyAqKioqKioqKioqIFBBR0VTIChhZG1pbikgKioqKioqKioqKgoKCgovLyAqKioqKioqKioqIExJQlJBUklFUyAmIENMQVNTRVMgKGFkbWluKSAqKioqKioqKioqCnJlcXVpcmVfb25jZSggJ2NsYXNzZXMvY29yZS5waHAnICk7CgpyZXF1aXJlX29uY2UoICdjbGFzc2VzL2ltcG9ydC5waHAnICk7CnBiX2JhY2t1cGJ1ZGR5OjokY2xhc3Nlc1snaW1wb3J0J10gPSBuZXcgcGJfYmFja3VwYnVkZHlfaW1wb3J0KCk7CgoKLy8gKioqKioqKioqKiBPVEhFUiAoYWRtaW4pICoqKioqKioqKioKCgo=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/init_admin.php,importbuddy/init_admin.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/init_global.php,importbuddy/init_global.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/init_global.php,importbuddy/init_global.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/license.txt,importbuddy/license.txt
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/license.txt,importbuddy/license.txt
###PACKDATA,FILE_START,/_importbuddy/importbuddy/readme.txt,importbuddy/readme.txt
ICogV2Vic2l0ZTogaHR0cDovL2l0aGVtZXMuY29tCiAqCiAqIEluc3RhbGxhdGlvbjoKICogCiAqIDEuIERvd25sb2FkIGFuZCB1bnppcCB0aGUgbGF0ZXN0IHJlbGVhc2UgemlwIGZpbGUKICogMi4gSWYgeW91IHVzZSB0aGUgV29yZFByZXNzIHBsdWdpbiB1cGxvYWRlciB0byBpbnN0YWxsIHRoaXMgcGx1Z2luIHNraXAgdG8gc3RlcCA0LgogKiAzLiBVcGxvYWQgdGhlIGVudGlyZSBwbHVnaW4gZGlyZWN0b3J5IHRvIHlvdXIgYC93cC1jb250ZW50L3BsdWdpbnMvYCBkaXJlY3RvcnkKICogNC4gQWN0aXZhdGUgdGhlIHBsdWdpbiB0aHJvdWdoIHRoZSAnUGx1Z2lucycgbWVudSBpbiBXb3JkUHJlc3MgQWRtaW5pc3RyYXRpb24KICogCiAqIFVzYWdlOgogKiAKICogMS4gTmF2aWdhdGUgdG8gdGhlIG5ldyBtZW51IGZvciB0aGlzIHBsdWdpbiBpbiB0aGUgV29yZHByZXNzIEFkbWluaXN0cmF0aW9uIFBhbmVsCiAqIDIuIFNlbGVjdCAnR2V0dGluZyBTdGFydGVkJyBmb3IgaW5zdHJ1Y3Rpb25zIGFuZCBhZGRpdGlvbmFsIGluZm9ybWF0aW9uLgogKg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/readme.txt,importbuddy/readme.txt
###PACKDATA,FILE_START,/_importbuddy/importbuddy/sample.ini.txt,importbuddy/sample.ini.txt
OyBEZWZhdWx0IHZhbHVlcyBjYW4gYmUgc2VlbiBpbjogaW1wb3J0YnVkZHkvY2xhc3Nlcy9yZXN0b3JlLnBocCAob3IgYmFja3VwYnVkZHkvY2xhc3Nlcy9yZXN0b3JlLnBocCkgaW4gdGhlIF9fY29uc3RydWN0KCkgZnVuY3Rpb24sIHdoZXJlICR0aGlzLT5fc3RhdGUgaXMgZmlyc3Qgc2V0LgoKdHlwZSA9IHJlc3RvcmUKYXJjaGl2ZSA9IGJhY2t1cC1iYWNrdXBidWRkeS1YWFhYWFhYWFhYWC56aXAKc2l0ZXVybCA9IGh0dHA6Ly9maW5hbHVybC5jb20KaG9tZXVybCA9IGh0dHA6Ly9maW5hbHVybC5jb20KcmVzdG9yZUZpbGVzID0gdHJ1ZQpyZXN0b3JlRGF0YWJhc2UgPSB0cnVlCm1pZ3JhdGVIdGFjY2VzcyA9IHRydWUKCjsgQm90aCBvZiB0aGVzZSBtdXN0IGJlIHRydWUgd2hlbiB1c2luZyAuaW5pIGZpbGUuCmluaW1vZGUgPSB0cnVlCmF1dG9BZHZhbmNlID0gdHJ1ZQoKW2RhdGFiYXNlU2V0dGluZ3NdCnNlcnZlciA9IGxvY2FsaG9zdApkYXRhYmFzZSA9IGRhdGFiYXNlX25hbWUKdXNlcm5hbWUgPSBkYXRhYmFzZV91c2VyCnBhc3N3b3JkID0gZGF0YWJhc2VfcGFzc3dvcmQKcHJlZml4ID0gd3BfCnJlbmFtZVByZWZpeCA9IHRydWUKd2lwZVByZWZpeCA9IGZhbHNlCndpcGVEYXRhYmFzZSA9IGZhbHNlCgpbY2xlYW51cF0KZGVsZXRlQXJjaGl2ZSA9IGZhbHNlCmRlbGV0ZVRlbXBGaWxlcyA9IHRydWUKZGVsZXRlSW1wb3J0QnVkZHkgPSBmYWxzZQpzZXRfYmxvZ19wdWJsaWMgPSAKZGVsZXRlSW1wb3J0QnVkZHlEaXJlY3RvcnkgPSB0cnVlCmRlbGV0ZUltcG9ydExvZyA9IHRydWUK
###PACKDATA,FILE_END,/_importbuddy/importbuddy/sample.ini.txt,importbuddy/sample.ini.txt
###PACKDATA,FILE_START,/_importbuddy/importbuddy/classes/auth.php,importbuddy/classes/auth.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/classes/auth.php,importbuddy/classes/auth.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/classes/index.php,importbuddy/classes/index.php
PD9waHAgLy8gU2lsZW5jZSBpcyBnb2xkZW4u
###PACKDATA,FILE_END,/_importbuddy/importbuddy/classes/index.php,importbuddy/classes/index.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/classes/test-db.php,importbuddy/classes/test-db.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/classes/test-db.php,importbuddy/classes/test-db.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/classes/wp-db.php,importbuddy/classes/wp-db.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/classes/wp-db.php,importbuddy/classes/wp-db.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax.php,importbuddy/controllers/ajax.php
PD9waHAKY2xhc3MgcGJfYmFja3VwYnVkZHlfYWpheCBleHRlbmRzIHBiX2JhY2t1cGJ1ZGR5X2FqYXhjb3JlIHsKfQ==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax.php,importbuddy/controllers/ajax.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/index.php,importbuddy/controllers/index.php
PD9waHAgLy8gU2lsZW5jZSBpcyBnb2xkZW4u
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/index.php,importbuddy/controllers/index.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/css/index.php,importbuddy/css/index.php
PD9waHAgLy8gU2lsZW5jZSBpcyBnb2xkZW4u
###PACKDATA,FILE_END,/_importbuddy/importbuddy/css/index.php,importbuddy/css/index.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/css/nprogress.css,importbuddy/css/nprogress.css
LyogTWFrZSBjbGlja3MgcGFzcy10aHJvdWdoICovCiNucHJvZ3Jlc3MgewogIHBvaW50ZXItZXZlbnRzOiBub25lOwp9CgojbnByb2dyZXNzIC5iYXIgewogIGJhY2tncm91bmQ6ICMyOWQ7CgogIHBvc2l0aW9uOiBmaXhlZDsKICB6LWluZGV4OiA3NTsKICB0b3A6IDQ4cHg7CiAgbGVmdDogMDsKCiAgd2lkdGg6IDEwMCU7CiAgaGVpZ2h0OiA0cHg7Cn0KCi8qIEZhbmN5IGJsdXIgZWZmZWN0ICovCiNucHJvZ3Jlc3MgLnBlZyB7Cgp9CgovKiBSZW1vdmUgdGhlc2UgdG8gZ2V0IHJpZCBvZiB0aGUgc3Bpbm5lciAqLwojbnByb2dyZXNzIC5zcGlubmVyIHsKICBkaXNwbGF5OiBibG9jazsKICBwb3NpdGlvbjogZml4ZWQ7CiAgei1pbmRleDogMTAzMTsKICB0b3A6IDY1cHg7CiAgcmlnaHQ6IDE1cHg7Cn0KCiNucHJvZ3Jlc3MgLnNwaW5uZXItaWNvbiB7CiAgd2lkdGg6IDQwcHg7CiAgaGVpZ2h0OiA0MHB4OwogIGJveC1zaXppbmc6IGJvcmRlci1ib3g7CgogIGJvcmRlcjogc29saWQgNHB4IHRyYW5zcGFyZW50OwogIGJvcmRlci10b3AtY29sb3I6ICMyOWQ7CiAgYm9yZGVyLWxlZnQtY29sb3I6ICMyOWQ7CiAgYm9yZGVyLXJhZGl1czogNTAlOwoKICAtd2Via2l0LWFuaW1hdGlvbjogbnByb2dyZXNzLXNwaW5uZXIgNDAwbXMgbGluZWFyIGluZmluaXRlOwogICAgICAgICAgYW5pbWF0aW9uOiBucHJvZ3Jlc3Mtc3Bpbm5lciA0MDBtcyBsaW5lYXIgaW5maW5pdGU7Cn0KCkAtd2Via2l0LWtleWZyYW1lcyBucHJvZ3Jlc3Mtc3Bpbm5lciB7CiAgMCUgICB7IC13ZWJraXQtdHJhbnNmb3JtOiByb3RhdGUoMGRlZyk7IH0KICAxMDAlIHsgLXdlYmtpdC10cmFuc2Zvcm06IHJvdGF0ZSgzNjBkZWcpOyB9Cn0KCkBrZXlmcmFtZXMgbnByb2dyZXNzLXNwaW5uZXIgewogIDAlICAgeyB0cmFuc2Zvcm06IHJvdGF0ZSgwZGVnKTsgfQogIDEwMCUgeyB0cmFuc2Zvcm06IHJvdGF0ZSgzNjBkZWcpOyB9Cn0K
###PACKDATA,FILE_END,/_importbuddy/importbuddy/css/nprogress.css,importbuddy/css/nprogress.css
###PACKDATA,FILE_START,/_importbuddy/importbuddy/css/style.css,importbuddy/css/style.css
QGltcG9ydCB1cmwoaHR0cHM6Ly9mb250cy5nb29nbGVhcGlzLmNvbS9jc3M/ZmFtaWx5PU9wZW4rU2Fuczo0MDBpdGFsaWMsNDAwLDcwMCk7CgoKLyoqKioqKioqKioqKioqKioqKioqKiAKCUJhc2ljcwoqKioqKioqKioqKioqKioqKioqKiovCgphIHsKCWNvbG9yOiAjMDA4NGNiOwoJdGV4dC1kZWNvcmF0aW9uOiBub25lOwp9CmE6aG92ZXIgewoJY29sb3I6ICM0NDQ7Cgl0ZXh0LWRlY29yYXRpb246IHVuZGVybGluZTsKfQoKLndpZGVmYXQgewoJLXdlYmtpdC1ib3JkZXItcmFkaXVzOiAzcHg7CgktbW96LWJvcmRlci1yYWRpdXM6IDNweDsKCWJvcmRlci1yYWRpdXM6IDNweDsKCWJvcmRlci1zcGFjaW5nOiAwOwoJYm9yZGVyLXN0eWxlOiBzb2xpZDsKCWJvcmRlci13aWR0aDogMXB4OwoJY2xlYXI6IGJvdGg7CgltYXJnaW46IDA7Cgl3aWR0aDogMTAwJTsKCWJhY2tncm91bmQtY29sb3I6ICNGRkZGRkY7Cglib3JkZXItY29sb3I6ICNERkRGREY7Cn0KLndpZGVmYXQgdGQsIAoud2lkZWZhdCB0aCB7Cglmb250LWZhbWlseTogJ09wZW4gU2FucycgLHNhbnMtc2VyaWY7Cglib3JkZXItYm90dG9tLXN0eWxlOiBzb2xpZDsKCWJvcmRlci1ib3R0b20td2lkdGg6IDFweDsKCWZvbnQtc2l6ZTogMTFweDsKCWJvcmRlci1jb2xvcjogI0RGREZERjsKfQoud2lkZWZhdCB0aCB7CgliYWNrZ3JvdW5kOiAjREZERkRGOwoJY29sb3I6ICMzMzMzMzM7Cglmb250LXNpemU6IDExcHg7Cgl0ZXh0LXNoYWRvdzogMCAxcHggMCByZ2JhKDI1NSwgMjU1LCAyNTUsIDAuOCk7CglsaW5lLWhlaWdodDogMS4zZW07CglwYWRkaW5nOiA3cHggN3B4IDhweDsKCXRleHQtYWxpZ246IGxlZnQ7Cn0KLndpZGVmYXQgdGQgewoJcGFkZGluZzogM3B4IDdweDsKCXZlcnRpY2FsLWFsaWduOiB0b3A7Cn0KaDEgewoJY29sb3I6ICM0NjQ2NDY7Cglmb250LXNpemU6IDI0cHg7Cglmb250LWZhbWlseTogJ09wZW4gU2FucycgLHNhbnMtc2VyaWY7Cglmb250LXN0eWxlOiBpdGFsaWM7CgltYXJnaW4tdG9wOiAwcHg7Cn0KaDIgewoJY29sb3I6ICM0NjQ2NDY7Cglmb250LXNpemU6IDIwcHg7Cglmb250LWZhbWlseTogJ09wZW4gU2FucycgLHNhbnMtc2VyaWY7Cglmb250LXN0eWxlOiBpdGFsaWM7CgltYXJnaW4tdG9wOiAtMTBweDsKfQpoMyB7Cglmb250LXNpemU6IDEuMmVtOwoJZm9udC13ZWlnaHQ6IDIwMDsKfQppbWcgewoJdmVydGljYWwtYWxpZ246IC0ycHg7CgltYXgtd2lkdGg6IDEwMCU7CgloZWlnaHQ6IGF1dG87Cn0KdGggewoJZm9udC13ZWlnaHQ6IG5vcm1hbDsKfQoKaW5wdXRbdHlwZT0idGV4dCJdLCAKaW5wdXRbdHlwZT0icGFzc3dvcmQiXSwgCnRleHRhcmVhIHsKCW1hcmdpbjogM3B4OwoJcGFkZGluZzogOHB4OwoJLW1vei1ib3JkZXItcmFkaXVzOjNweCAzcHggM3B4IDNweDsKCS13ZWJraXQtYm9yZGVyLXJhZGl1czogM3B4OwoJYm9yZGVyLXJhZGl1czogM3B4OwoJYm9yZGVyLXN0eWxlOnNvbGlkOwoJYm9yZGVyLXdpZHRoOjFweDsKCWJvcmRlci1jb2xvcjogI0Q2RDZENjsKCS13ZWJraXQtYm94LXNpemluZzogYm9yZGVyLWJveDsKCS1tb3otYm94LXNpemluZzpib3JkZXItYm94OwoJYm94LXNpemluZzogYm9yZGVyLWJveDsKCQoJZm9udC1zaXplOiAxLjJlbTsKCWZvbnQtZmFtaWx5OiAnT3BlbiBTYW5zJyAsc2Fucy1zZXJpZjsKfQoKaW5wdXRbdHlwZT0idGV4dCJdOmZvY3VzLCAKaW5wdXRbdHlwZT0icGFzc3dvcmQiXTpmb2N1cywgCnRleHRhcmVhOmZvY3VzIHsKCW91dGxpbmU6bm9uZTsKCWJvcmRlci1jb2xvcjogIzk5OTsKfQp0ZXh0YXJlYSB7Cglmb250LWZhbWlseTogc2Fucy1zZXJpZjsKCWZvbnQtc2l6ZTogMTNweDsKCWxpbmUtaGVpZ2h0OiAxLjRlbTsKCWNvbG9yOiAjNDY0NjQ2OwoJd2lkdGg6IDEwMCU7CgltaW4taGVpZ2h0OiAyMDBweDsKfQoKbGFiZWwgewoJd2lkdGg6IDIwMHB4OwoJbWFyZ2luLXRvcDogN3B4Owp9CgovKiBCdXR0b25zCi0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0qLwoKLml0LWJ1dHRvbiwKLmJ1dHRvbiwKLmJ1dHRvbi1wcmltYXJ5IHsKCWRpc3BsYXk6IGlubGluZS1ibG9jazsKCWJvcmRlcjpub25lOwoJb3V0bGluZTpub25lOwoJcG9zaXRpb246IHJlbGF0aXZlOwoJbWFyZ2luOiAwLjVlbSAwLjI1ZW07CglwYWRkaW5nOiAuNWVtIDFlbTsKCWJhY2tncm91bmQ6ICMyRUEyQ0M7Cgljb2xvcjogI2ZmZjsKCXRleHQtZGVjb3JhdGlvbjogbm9uZTsKCWZvbnQtc2l6ZTogMS4xMjVlbTsKCWJvcmRlci1ib3R0b206IDJweCBzb2xpZCAjMjc3NjkzOwoJYm9yZGVyLXJhZGl1czogM3B4Owp9CgouaXQtYnV0dG9uOmhvdmVyLAouYnV0dG9uOmhvdmVyLAouYnV0dG9uLXByaW1hcnk6aG92ZXIgewoJYm9yZGVyLWJvdHRvbS1jb2xvcjogIzEzNDU1QjsKCWNvbG9yOiAjRkZGRkZGOwoJdGV4dC1kZWNvcmF0aW9uOiBub25lOwoJY3Vyc29yOnBvaW50ZXI7Cn0KCi5pdC1idXR0b246aG92ZXIgewoJYmFja2dyb3VuZDogIzNhYjFkYjsKfQoKLmJ1dHRvbi1zZWNvbmRhcnkgewoJYmFja2dyb3VuZDogI2YxZjFmMTsKCWNvbG9yOiAjNjY2OwoJYm9yZGVyOiAxcHggc29saWQgI2ViZWJlYjsKCWJvcmRlci1ib3R0b206IDJweCBzb2xpZCAjYzljOWM5Owp9CgouYnV0dG9uLXNlY29uZGFyeTpob3ZlciB7Cgljb2xvcjogIzQ0NDsKCWJvcmRlci1ib3R0b20tY29sb3I6ICM5OTk7Cn0KCi5idXR0b24tdGVydGlhcnkgewoJYmFja2dyb3VuZDogI2YxZjFmMTsKCWNvbG9yOiAjNjY2OwoJYm9yZGVyOiAxcHggc29saWQgI2ViZWJlYjsKCWJvcmRlci1ib3R0b206IDJweCBzb2xpZCAjYzljOWM5OwoJcGFkZGluZzogMCAxZW07Cglmb250LXNpemU6IC44NzVlbTsKfQoKLmJ1dHRvbi10ZXJ0aWFyeTpob3ZlciB7Cgljb2xvcjogIzQ0NDsKCWJvcmRlci1ib3R0b20tY29sb3I6ICM5OTk7Cn0KCi5idXR0b25fZGlzYWJsZWQgewoJb3BhY2l0eTogLjc7Cn0KCgoKLyogRXJyb3JzIGFuZCBNZXNzYWdlcwotLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tKi8KCi5wYl9iYWNrdXBidWRkeV9hbGVydCB7CgltYXJnaW46IDAgMCAyZW0gMDsKCWJhY2tncm91bmQtY29sb3I6I0ZGRkZFMDsKCWJvcmRlcjogMXB4IHNvbGlkICNFNkRCNTU7CglwYWRkaW5nOiAxMHB4OwoJLXdlYmtpdC1ib3JkZXItcmFkaXVzOiAzcHg7CgktbW96LWJvcmRlci1yYWRpdXM6IDNweDsKCWJvcmRlci1yYWRpdXM6IDNweDsKfQoKLmVycm9yLCAKLnVwZGF0ZWQgewoJZm9udC1zaXplOiAwLjhlbTsKfQouZXJyb3IgcCwgCi51cGRhdGVkIHAgewoJbWFyZ2luOiAwOwoJcGFkZGluZzogMDsKfQoKCgoKCi8qIFBhZ2UgTGF5b3V0Ci0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0qLwpib2R5IHsKCS8vYmFja2dyb3VuZDogI0ZGRkZGRjsKCWZvbnQtZmFtaWx5OiAnT3BlbiBTYW5zJyAsc2Fucy1zZXJpZjsKCWZvbnQtc2l6ZTogMWVtOwoJY29sb3I6ICM0NjQ2NDY7Cglmb250LXdlaWdodDogMjAwOwoJbWFyZ2luOiAwOwp9CgoudG9wTmF2IHsKCXBvc2l0aW9uOiBmaXhlZDsKCXRvcDogMDsKCXdpZHRoOiAxMDAlOwoJYmFja2dyb3VuZDogIzJhMmYzMzsKCWNvbG9yOiAjZmZmOwoJZm9udC1zaXplOiAwLjllbTsKCW92ZXJmbG93OmhpZGRlbjsKCXotaW5kZXg6IDkwMDA7Cn0KLnRvcE5hdiBhIHsKCWRpc3BsYXk6IGJsb2NrOwoJZmxvYXQ6bGVmdDsKCW1hcmdpbjogMCBhdXRvOwoJY29sb3I6ICNmZmY7CgljdXJzb3I6IHBvaW50ZXI7Cgl0ZXh0LWFsaWduOmNlbnRlcjsKCXBhZGRpbmc6IDFlbTsKCWJhY2tncm91bmQ6ICM0MTQ3NGQ7Cn0KLnRvcE5hdiBhOmhvdmVyLAoudG9wTmF2IC5hY3RpdmVQYWdlIHsKCWJhY2tncm91bmQ6ICMzMjM3M2M7Cgl0ZXh0LWRlY29yYXRpb246IG5vbmU7Cgljb2xvcjogI2ZmZjsKfQoKLnRvcE5hdiAuYWN0aXZlUGFnZSB7Cgljb2xvcjogIzAwQjdGRjsKfQojbWluaUZyYW1lIHsKCW1hcmdpbi10b3A6IDJweDsKfQoKLm1haW5fYm94X3dyYXB7Cgl3aWR0aDogMTAwJTsKCW1heC13aWR0aDogODUwcHg7CgltYXJnaW46MmVtIGF1dG87CglwYWRkaW5nOiAwcHg7Cglib3JkZXI6IDFweCBzb2xpZCAjRDZENkQ2OwoJYmFja2dyb3VuZDogI0ZGRkZGRjsKfQoKLm1haW5fYm94IHsKCXBhZGRpbmc6IDJlbTsKfQoKI3BiX2JhY2t1cGJ1ZGR5X3N0YXR1c193cmFwIHsKCXBhZGRpbmc6IDJlbSAyZW0gMCAyZW0KfQoKLm1haW5fYm94X2hlYWQgewoJYmFja2dyb3VuZDogIzQxNDc0ZDsKCXBhZGRpbmc6IC41ZW0gMWVtOwoJZm9udC1mYW1pbHk6ICdPcGVuIFNhbnMnICxzYW5zLXNlcmlmOwoJZm9udC13ZWlnaHQ6IG5vcm1hbDsKCWZvbnQtc2l6ZTogMS4yNWVtOwoJYm9yZGVyLWJvdHRvbTogMXB4IHNvbGlkICNENkQ2RDY7CgliYWNrZ3JvdW5kOiAjZmZmOwoJYm9yZGVyLWxlZnQ6IDNweCBzb2xpZCAjMDBCN0ZGOwp9Cgouc3RlcF9udW1iZXIgewoJY29sb3I6ICMwMEI3RkY7Cglmb250LXdlaWdodDogYm9sZDsKfQoKLm1haW5fYm94X2Zvb3QgewoJcGFkZGluZzogMTBweDsKCWZvbnQtZmFtaWx5OiAnT3BlbiBTYW5zJyAsc2Fucy1zZXJpZjsKCWNvbG9yOiAjNDY0NjQ2OwoJYm9yZGVyLXRvcDogMXB4IHNvbGlkICNENkQ2RDY7Cgl0ZXh0LWFsaWduOiBjZW50ZXI7Cn0KCi53cmFwIHsKCW1hcmdpbi10b3A6IDEwcHg7Cglwb3NpdGlvbjogcmVsYXRpdmU7Cgl0ZXh0LWFsaWduOiBsZWZ0OwoJbWFyZ2luLWxlZnQ6IGF1dG87CgltYXJnaW4tcmlnaHQ6IGF1dG87Cn0KCgoKCgouZm9vdGVyX3RleHQgewoJZm9udC1zaXplOiAwLjdlbTsKCWNvbG9yOiAjNzc3Owp9Ci5mb290ZXIgewoJY2xlYXI6IGJvdGg7CgltYXJnaW4tdG9wOiAyNXB4OwoJbWFyZ2luLWJvdHRvbTogNTBweDsKCXRleHQtYWxpZ246Y2VudGVyOwp9CgouYmFja3VwX3NlbGVjdF9idXR0b25zIHsKCW1hcmdpbjogMCAwIDNlbSAwOwp9CgouYmFja3VwX3NlbGVjdF90ZXh0IHNwYW4gewoJZGlzcGxheTppbmxpbmUtYmxvY2s7CgltYXgtd2lkdGg6IDUwMHB4OwoJb3ZlcmZsb3c6c2Nyb2xsOwoJdmVydGljYWwtYWxpZ246IGJvdHRvbTsKfQouYmFja3VwX3NlbGVjdF90ZXh0IHNwYW46Oi13ZWJraXQtc2Nyb2xsYmFyIHsgCglkaXNwbGF5OiBub25lOyAKfQoKLnJvdW5kLXdyYXAgewoJbWFyZ2luOiAxZW0gMDsKCXBhZGRpbmc6IDA7Cn0KCi5yb3VuZC13cmFwIGxpIHsKCWxpc3Qtc3R5bGU6IG5vbmU7Cglib3JkZXItYm90dG9tOiAxcHggc29saWQgI2RmZGZkZjsKCW1hcmdpbi1ib3R0b206IDFlbTsKCXBhZGRpbmctYm90dG9tOiAxZW07Cn0KCi5yb3VuZC13cmFwIGxpOmxhc3QtY2hpbGQgewoJYm9yZGVyOm5vbmU7Cn0KCi5zZXR0aW5nQ29weSB7Cgl0ZXh0LWFsaWduOiBjZW50ZXI7Cn0KCgoKCgoKCiNpbXBvcnRidWRkeV9zdGF0dXMgewoJYm9yZGVyOiAwcHg7CgltYXJnaW46IC0xNXB4OwoJbWFyZ2luLWJvdHRvbTogMHB4OwoJd2lkdGg6IDEwMCU7CgltYXgtd2lkdGg6IDc0MHB4OwoJaGVpZ2h0OiAyMDBweDsKfQoKCi5iYWNrdXBfc2VsZWN0X3RleHQgewoJbWFyZ2luLWJvdHRvbTogMTJweDsKfQoKCgoKCi5tZW51IHsKCXBhZGRpbmc6IDhweDsKCXRleHQtYWxpZ246IGNlbnRlcjsKCWJhY2tncm91bmQtY29sb3I6ICNDQ0NDQ0M7Cglmb250LXdlaWdodDogYm9sZDsKfQoKLnRvZ2dsZSB7CgljdXJzb3I6IHBvaW50ZXI7Cn0KLnRvZ2dsZWQgewoJZGlzcGxheTogbm9uZTsKCWJvcmRlcjogMXB4IHNvbGlkICNDQ0NDQ0M7CgltYXJnaW46IDRweDsKCXBhZGRpbmc6IDhweDsKCS13ZWJraXQtYm9yZGVyLXJhZGl1czogNHB4OwoJLW1vei1ib3JkZXItcmFkaXVzOiA0cHg7Cglib3JkZXItcmFkaXVzOiA0cHg7Cn0KCiN0b29sdGlwIHsKCXBvc2l0aW9uOiBhYnNvbHV0ZTsKCXotaW5kZXg6IDk5OTk5OTsKCWJvcmRlcjogMXB4IHNvbGlkICMxMTE7CgliYWNrZ3JvdW5kLWNvbG9yOiAjZWVlOwoJcGFkZGluZzogNXB4OwoJbWF4LXdpZHRoOiAzMDBweDsKCW9wYWNpdHk6IDAuODU7Cglib3JkZXItcmFkaXVzOiA1cHg7Cgktd2Via2l0LWJvcmRlci1yYWRpdXM6IDVweDsKCS1tb3otYm9yZGVyLXJhZGl1czogNXB4Owp9CiN0b29sdGlwIGgzLCAjdG9vbHRpcCBkaXYgeyBtYXJnaW46IDA7IH0KLmxpZ2h0IHsKCWNvbG9yOiAjQUZBRkFGOwp9CiNwYl9pbXBvcnRidWRkeV93b3JraW5nIHsKCXRleHQtYWxpZ246IGNlbnRlcjsKCXBhZGRpbmctdG9wOiAyMHB4Owp9CgoKCmhyIHsKCWJvcmRlci10b3A6IDFweCBkb3R0ZWQgI0Q2RDZENjsKCWJvcmRlci1ib3R0b206IDA7CgltYXJnaW4tdG9wOiAzMHB4OwoJbWFyZ2luLWJvdHRvbTogMzBweDsKfQoKCgovKiBUYWJzCi0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0qLwoudWktdGFicyB7Cglib3JkZXItdG9wOiAxcHggc29saWQgI0RGREZERjsKCW1hcmdpbi10b3A6IDIwcHg7Cglmb250LXNpemU6IDEuM2VtOwp9IC8qIHBhZGRpbmc6IC4yZW07IHpvb206IDE7ICovCi51aS10YWJzIC51aS10YWJzLW5hdiB7Cgl6LWluZGV4OiAxNTsKCWxpc3Qtc3R5bGU6IG5vbmU7Cglwb3NpdGlvbjogcmVsYXRpdmU7CglwYWRkaW5nOiAwcHggMHB4IDBweDsKCW1hcmdpbi10b3A6IC0xNXB4OwoJbWFyZ2luLWxlZnQ6IDEwcHg7Cn0KLnVpLXRhYnMgLnVpLXRhYnMtbmF2IGxpIHsgCgltYXJnaW46IC0yNXB4IDNweCAtMXB4IDBweDsgCglwb3NpdGlvbjogcmVsYXRpdmU7IAoJZmxvYXQ6IGxlZnQ7IAoJcGFkZGluZzogMDsgCgl0ZXh0LWFsaWduOiBjZW50ZXI7IAoJCn0KLnVpLXRhYnMgLnVpLXRhYnMtbmF2IGxpIGEgewoJY29sb3I6ICM1MzU3NUQ7CgloZWlnaHQ6IDM0cHg7CglmbG9hdDogbGVmdDsKCXRleHQtZGVjb3JhdGlvbjogbm9uZTsKCXBhZGRpbmctbGVmdDogMTJweDsKCXBhZGRpbmctcmlnaHQ6IDEycHg7CgktbW96LWJvcmRlci1yYWRpdXM6IDVweCA1cHggMHB4IDBweDsKCS13ZWJraXQtYm9yZGVyLXJhZGl1czogNXB4IDVweCAwcHggMHB4OwoJYm9yZGVyOiAxcHggc29saWQgI0RGREZERjsKCWJvcmRlci1ib3R0b206IDBweCBzb2xpZCByZWQ7CglvdXRsaW5lOiBub25lOwoJcGFkZGluZy10b3A6IDVweDsKfQoudWktdGFicyAudWktdGFicy1uYXYgbGkgYTpob3ZlciB7IGJhY2tncm91bmQtY29sb3I6ICNGNUY1RjU7IH0KLnVpLXRhYnMgLnVpLXRhYnMtbmF2IGxpLnVpLXRhYnMtc2VsZWN0ZWQgeyAgfSAvKiBwYWRkaW5nLWJvdHRvbTogMHB4OyAqLwoudWktdGFicyAudWktdGFicy1uYXYgbGkudWktdGFicy1zZWxlY3RlZCBhLCAKLnVpLXRhYnMgLnVpLXRhYnMtbmF2IGxpLnVpLXN0YXRlLWRpc2FibGVkIGEsIAoudWktdGFicyAudWktdGFicy1uYXYgbGkudWktc3RhdGUtcHJvY2Vzc2luZyBhIHsKCWhlaWdodDogMzRweDsKCWN1cnNvcjogdGV4dDsKCWJhY2tncm91bmQtY29sb3I6ICNGRkZGRkY7Cglib3JkZXItYm90dG9tOiAwcHg7Cn0KLnVpLXRhYnMgLnVpLXRhYnMtbmF2IGxpIGEsIAoudWktdGFicy51aS10YWJzLWNvbGxhcHNpYmxlIC51aS10YWJzLW5hdiBsaS51aS10YWJzLXNlbGVjdGVkIGEgeyBjdXJzb3I6IHBvaW50ZXI7IH0gLyogZmlyc3Qgc2VsZWN0b3IgaW4gZ3JvdXAgc2VlbXMgb2Jzb2xldGUsIGJ1dCByZXF1aXJlZCB0byBvdmVyY29tZSBidWcgaW4gT3BlcmEgYXBwbHlpbmcgY3Vyc29yOiB0ZXh0IG92ZXJhbGwgaWYgZGVmaW5lZCBlbHNld2hlcmUuLi4gKi8KLnVpLXRhYnMgLnVpLXRhYnMtcGFuZWwgeyBwYWRkaW5nLXRvcDogM3B4OyBkaXNwbGF5OiBibG9jazsgYm9yZGVyLXdpZHRoOiAwOyBiYWNrZ3JvdW5kOiBub25lOyB9Ci51aS10YWJzIC51aS10YWJzLWhpZGUgeyBkaXNwbGF5OiBub25lICFpbXBvcnRhbnQ7IH0KLnRhYnMtaXRlbSB7CgkvL3BhZGRpbmctbGVmdDogMTZweDsKCXBhZGRpbmctdG9wOiAxNnB4OwoJLy9wYWRkaW5nLXRvcDogMjhweDsKCS8vcGFkZGluZy1ib3R0b206IDI4cHg7CgliYWNrZ3JvdW5kOiAjRkZGRkZGOwoJZm9udC1zaXplOiAxNnB4Owp9CgojcGx1Z2luYnVkZHktdGFicyB7CgltYXJnaW4tdG9wOiA0ZW07Cn0KCiNwbHVnaW5idWRkeS10YWJzLnVpLXRhYnMgewoJCn0KI3BsdWdpbmJ1ZGR5LXRhYnMudWktdGFicyAudWktdGFicy1uYXYgbGkgYXsKCS13ZWJraXQtYm9yZGVyLXJhZGl1czogMDsKCS1tb3otYm9yZGVyLXJhZGl1czogMDsKCWJvcmRlci1yYWRpdXM6IDA7Cn0KCi53aWRlZmF0IHsKCWJvcmRlcjogMDsKfQouZGVzY3JpcHRpb24gewoJY29sb3I6ICM2NjY2NjY7CgltYXJnaW46IDFlbTsKCWZvbnQtc3R5bGU6IG5vcm1hbDsgCglsaW5lLWhlaWdodDogMjZweDsKfQoKCi5tb2RhbCB7Cgl3aWR0aDogNzAwcHg7CgliYWNrZ3JvdW5kOiAjRkZGRkZGOwoJYm9yZGVyLXJhZGl1czogNXB4OwoJYm9yZGVyOiAxcHggc29saWQgI0Q2RDZENjsKCS1tb3otYm9yZGVyLXJhZGl1czogNXB4OwoJLXdlYmtpdC1ib3JkZXItcmFkaXVzOiA1cHg7CglvdmVyZmxvdzogaGlkZGVuOwoJcGFkZGluZzogMHB4OwoJaGVpZ2h0OiBpbmhlcml0OwoJb3ZlcmZsb3c6IHNjcm9sbDsKfQoubW9kYWxfaGVhZGVyIHsKCWJhY2tncm91bmQ6ICM0MTQ3NGQ7CglwYWRkaW5nOiAxZW07Cglmb250LWZhbWlseTogJ09wZW4gU2FucycgLHNhbnMtc2VyaWY7Cglmb250LXdlaWdodDogbm9ybWFsOwoJYm9yZGVyLWJvdHRvbTogMXB4IHNvbGlkICNENkQ2RDY7CgliYWNrZ3JvdW5kOiAjZmZmOwoJYm9yZGVyLWxlZnQ6IDNweCBzb2xpZCAjMDBCN0ZGOwp9Ci5tb2RhbF9oZWFkZXIgaDIgewoJZm9udC1mYW1pbHk6ICdPcGVuIFNhbnMnICxzYW5zLXNlcmlmOwoJY29sb3I6ICM0NjQ2NDY7Cglmb250LXNpemU6IDEuNDNlbTsKCWZvbnQtc3R5bGU6IG5vcm1hbDsKCWxpbmUtaGVpZ2h0OiAxOwoJbWFyZ2luOiAwIDAgNXB4Owp9Ci5tb2RhbF9jbG9zZSB7CglmbG9hdDogcmlnaHQ7Cgljb2xvcjogIzhmOGY4ZjsKCWZvbnQtc2l6ZTogMS41ZW07CgljdXJzb3I6IHBvaW50ZXI7CgkKCXBvc2l0aW9uOiBhYnNvbHV0ZTsKCXJpZ2h0OiAxNXB4OwoJdG9wOiAxNXB4OwoJLXdlYmtpdC1ib3gtc2l6aW5nOmNvbnRlbnQtYm94OwoJLW1vei1ib3gtc2l6aW5nOmNvbnRlbnQtYm94OwoJYm94LXNpemluZzpjb250ZW50LWJveDsKCWRpc3BsYXk6aW5saW5lLWJsb2NrOwoJd2lkdGg6MjVweDsKCWhlaWdodDoyNXB4OwoJYm9yZGVyOjJweCBzb2xpZCB0cmFuc3BhcmVudDsKCWJvcmRlci1yYWRpdXM6NTAlOwoJbGluZS1oZWlnaHQ6MWVtOwoJdGV4dC1kZWNvcmF0aW9uOm5vbmU7Cgl0ZXh0LWFsaWduOmNlbnRlcjsKCS13ZWJraXQtdHJhbnNpdGlvbjphbGwgLjJzIGxpbmVhcjsKCS1tb3otdHJhbnNpdGlvbjphbGwgLjJzIGxpbmVhcjsKCXRyYW5zaXRpb246YWxsIC4ycyBsaW5lYXI7Cn0KCi5tb2RhbF9jbG9zZTpob3ZlcnsKCWJvcmRlci1jb2xvcjojRTE3OTdBICFpbXBvcnRhbnQ7Cgljb2xvcjojRTE3OTdBOwoJdGV4dC1kZWNvcmF0aW9uOiBub25lOwp9CgoubW9kYWxfY29udGVudCB7CglwYWRkaW5nOiAyMHB4OwoJCn0KI2xlYW5fb3ZlcmxheSB7CiAgICBwb3NpdGlvbjogZml4ZWQ7CiAgICB6LWluZGV4OjEwMDsKICAgIHRvcDogMHB4OwogICAgbGVmdDogMHB4OwogICAgaGVpZ2h0OjEwMCU7CiAgICB3aWR0aDoxMDAlOwogICAgYmFja2dyb3VuZDogIzAwMDsKICAgIGRpc3BsYXk6IG5vbmU7Cn0KCgojcGJfY3JlYXRlZGJfbW9kYWwgewoJaGVpZ2h0OiA4NSU7CglvdmVyZmxvdzogYXV0bzsKfQoKCgoucGJfbGFiZWwgewoJLXdlYmtpdC1ib3JkZXItcmFkaXVzOiAzcHg7CgktbW96LWJvcmRlci1yYWRpdXM6IDNweDsKCWJvcmRlci1yYWRpdXM6IDNweDsKfQoucGJfbGFiZWwgewoJZGlzcGxheTogaW5saW5lLWJsb2NrOwoJcGFkZGluZzogMnB4IDRweDsKCWZvbnQtc2l6ZTogMTEuODQ0cHg7Cglmb250LXdlaWdodDogYm9sZDsKCWxpbmUtaGVpZ2h0OiAxNHB4OwoJY29sb3I6IHdoaXRlOwoJdGV4dC1zaGFkb3c6IDAgLTFweCAwIHJnYmEoMCwgMCwgMCwgMC4yNSk7Cgl3aGl0ZS1zcGFjZTogbm93cmFwOwoJdmVydGljYWwtYWxpZ246IGJhc2VsaW5lOwoJYmFja2dyb3VuZC1jb2xvcjogIzk5OTsKfQoucGJfbGFiZWwtc3VjY2VzcyB7CgliYWNrZ3JvdW5kLWNvbG9yOiAjNDY4ODQ3Owp9Ci5wYl9sYWJlbC13YXJuaW5nIHsKCWJhY2tncm91bmQtY29sb3I6ICNGODk0MDY7Cn0KLnBiX2xhYmVsLWVycm9yIHsKCWJhY2tncm91bmQtY29sb3I6IHJlZDsKfQoucGJfbGFiZWwtaW1wb3J0YW50IHsKCWJhY2tncm91bmQtY29sb3I6ICNkZDQ1NDI7IC8vI0I5NEE0ODsKfQoucGJfbGFiZWwtaW5mbyB7CgliYWNrZ3JvdW5kLWNvbG9yOiAjM0E4N0FEOwp9Ci5wYl9sYWJlbC1pbnZlcnNlIHsKCWJhY2tncm91bmQtY29sb3I6ICMzMzM7Cn0KCi5leHBhbmRlcjpob3ZlciB7Cgl0ZXh0LWRlY29yYXRpb246IG5vbmU7Cn0KLmV4cGFuZGVyLWJveCB7CglwYWRkaW5nLWJvdHRvbTogNnB4Owp9Ci5leHBhbmRlci1ib3ggLmNvbnRlbnQgewoJZGlzcGxheTogbm9uZTsKCXBhZGRpbmc6IDEwcHg7CgltYXJnaW4tbGVmdDogNHB4OwoJYm9yZGVyLWxlZnQ6IDZweCBzb2xpZCAjZjVmNWY1OwoJbWFyZ2luLWJvdHRvbTogMTJweDsKCW1hcmdpbi10b3A6IDEycHg7CgltYXJnaW4tYm90dG9tOiAxMnB4Owp9Ci5leHBhbmRlci5jb2xsYXBzZWQgewoJcGFkZGluZy1sZWZ0OiAxM3B4OwoJYmFja2dyb3VuZC1wb3NpdGlvbjogbGVmdCBjZW50ZXI7CgliYWNrZ3JvdW5kLXJlcGVhdDogbm8tcmVwZWF0OwoJYmFja2dyb3VuZC1pbWFnZTogdXJsKC4uL2ltYWdlcy9jb2xsYXBzZWQuZ2lmKTsKfQouZXhwYW5kZXIuZXhwYW5kZWQgewoJcGFkZGluZy1sZWZ0OiAxM3B4OwoJYmFja2dyb3VuZC1wb3NpdGlvbjogbGVmdCBjZW50ZXI7CgliYWNrZ3JvdW5kLXJlcGVhdDogbm8tcmVwZWF0OwoJYmFja2dyb3VuZC1pbWFnZTogdXJsKC4uL2ltYWdlcy9leHBhbmRlZC5naWYpOwp9CgoKI3BiX2JhY2t1cGJ1ZGR5X3N0YXR1c193cmFwIHsKCWRpc3BsYXk6IG5vbmU7Cn0KCi5lcnJvcl9hbGVydF9ib3ggewoJYm9yZGVyLWxlZnQ6IDNweCBzb2xpZCByZWQ7CgliYWNrZ3JvdW5kOiByZ2IoMjU1LCAyMDAsIDIwMCk7Cn0KLmVycm9yX2FsZXJ0X3RpdGxlIHsKCWRpc3BsYXk6IGJsb2NrOwp9Ci5iYWNrdXBidWR5X2Vycm9yX2xpc3QgewoJZm9udC1zaXplOiAxNHB4Owp9Cgoud2FybmluZ19hbGVydF9ib3ggewoJYm9yZGVyLWxlZnQ6IDNweCBzb2xpZCBvcmFuZ2U7CgliYWNrZ3JvdW5kOiByZ2IoMjU1LCAyNTUsIDIwMCk7CgltYXgtaGVpZ2h0OiAyMjBweDsKCW92ZXJmbG93OiBzY3JvbGw7Cglmb250LXNpemU6IDAuOWVtOwp9Ci53YXJuaW5nX2FsZXJ0X3RpdGxlIHsKCWRpc3BsYXk6IGJsb2NrOwp9Ci5iYWNrdXBidWR5X3dhcm5pbmdfbGlzdCB7Cglmb250LXNpemU6IDE0cHg7Cn0KCi5kYXRhYmFzZV9yZXN0b3JlX3RhYmxlX3NlbGVjdCB7CgltYXgtaGVpZ2h0OiAyMDBweDsKCW92ZXJmbG93OiBzY3JvbGw7Cglib3JkZXI6IDFweCBzb2xpZCAjZWNlY2VjOwp9Ci5kYXRhYmFzZV9yZXN0b3JlX3RhYmxlX3NlbGVjdDo6LXdlYmtpdC1zY3JvbGxiYXIgewoJLXdlYmtpdC1hcHBlYXJhbmNlOiBub25lOwoJd2lkdGg6IDExcHg7CgloZWlnaHQ6IDExcHg7Cn0KLmRhdGFiYXNlX3Jlc3RvcmVfdGFibGVfc2VsZWN0Ojotd2Via2l0LXNjcm9sbGJhci10aHVtYiB7Cglib3JkZXItcmFkaXVzOiA4cHg7Cglib3JkZXI6IDJweCBzb2xpZCB3aGl0ZTsgLyogc2hvdWxkIG1hdGNoIGJhY2tncm91bmQsIGNhbid0IGJlIHRyYW5zcGFyZW50ICovCgliYWNrZ3JvdW5kLWNvbG9yOiByZ2JhKDAsIDAsIDAsIC4xKTsKfQ==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/css/style.css,importbuddy/css/style.css
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/collapsed.gif,importbuddy/images/collapsed.gif
R0lGODlhBgAHALMKAM7Ozr6+vq6urp6enoWFhaampt7e3u/v742NjX19ff///wAAAAAAAAAAAAAAAAAAACH5BAEAAAoALAAAAAAGAAcAAAQVEAFFVUrD0HvF4RfCEYGVFAeFaFUEADs=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/collapsed.gif,importbuddy/images/collapsed.gif
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/expanded.gif,importbuddy/images/expanded.gif
R0lGODlhBwAGALMKAM7Ozr6+vq6urp6enoWFhaampt7e3u/v742NjX19ff///wAAAAAAAAAAAAAAAAAAACH5BAEAAAoALAAAAAAHAAYAAAQWEKU5kaETqEKHUgcxGZ8SJEL5IccXAQA7
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/expanded.gif,importbuddy/images/expanded.gif
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/gray-grad.png,importbuddy/images/gray-grad.png
iVBORw0KGgoAAAANSUhEUgAAAAUAAAAfCAIAAACgQJBPAAAAA3NCSVQICAjb4U/gAAAACXBIWXMAAAsSAAALEgHS3X78AAAAIXRFWHRTb2Z0d2FyZQBNYWNyb21lZGlhIEZpcmV3b3JrcyA0LjDqJid1AAAAFnRFWHRDcmVhdGlvbiBUaW1lADEwLzI0LzA4KQ6r+wAAAClJREFUeJxjfPv2LQMSYPn//z8yn4kBFaDzqa0eXZ5U9QMtT6l5tFYPADsXLPcJwrwLAAAAAElFTkSuQmCC
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/gray-grad.png,importbuddy/images/gray-grad.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/icon_16x16.png,importbuddy/images/icon_16x16.png
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/icon_16x16.png,importbuddy/images/icon_16x16.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/icon_32x32.png,importbuddy/images/icon_32x32.png
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/icon_32x32.png,importbuddy/images/icon_32x32.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/index.php,importbuddy/images/index.php
PD9waHAgLy8gU2lsZW5jZSBpcyBnb2xkZW4u
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/index.php,importbuddy/images/index.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/loading.gif,importbuddy/images/loading.gif
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/loading.gif,importbuddy/images/loading.gif
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/loading_large.gif,importbuddy/images/loading_large.gif
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/loading_large.gif,importbuddy/images/loading_large.gif
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/white-grad.png,importbuddy/images/white-grad.png
iVBORw0KGgoAAAANSUhEUgAAAAUAAAAeCAYAAADkftS9AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAACF0RVh0U29mdHdhcmUATWFjcm9tZWRpYSBGaXJld29ya3MgNC4w6iYndQAAABZ0RVh0Q3JlYXRpb24gVGltZQAxMS8xNy8wONpsdXEAAAAlSURBVHicY/z///9/BjTAhC7AwMDAwIJFIXbBoaJ9qLhz+IUSAIMMOibeSzRBAAAAAElFTkSuQmCC
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/white-grad.png,importbuddy/images/white-grad.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/ejs.js,importbuddy/js/ejs.js
KGZ1bmN0aW9uKCl7CiAgICAKCnZhciByc3BsaXQgPSBmdW5jdGlvbihzdHJpbmcsIHJlZ2V4KSB7Cgl2YXIgcmVzdWx0ID0gcmVnZXguZXhlYyhzdHJpbmcpLHJldEFyciA9IG5ldyBBcnJheSgpLCBmaXJzdF9pZHgsIGxhc3RfaWR4LCBmaXJzdF9iaXQ7Cgl3aGlsZSAocmVzdWx0ICE9IG51bGwpCgl7CgkJZmlyc3RfaWR4ID0gcmVzdWx0LmluZGV4OyBsYXN0X2lkeCA9IHJlZ2V4Lmxhc3RJbmRleDsKCQlpZiAoKGZpcnN0X2lkeCkgIT0gMCkKCQl7CgkJCWZpcnN0X2JpdCA9IHN0cmluZy5zdWJzdHJpbmcoMCxmaXJzdF9pZHgpOwoJCQlyZXRBcnIucHVzaChzdHJpbmcuc3Vic3RyaW5nKDAsZmlyc3RfaWR4KSk7CgkJCXN0cmluZyA9IHN0cmluZy5zbGljZShmaXJzdF9pZHgpOwoJCX0JCQoJCXJldEFyci5wdXNoKHJlc3VsdFswXSk7CgkJc3RyaW5nID0gc3RyaW5nLnNsaWNlKHJlc3VsdFswXS5sZW5ndGgpOwoJCXJlc3VsdCA9IHJlZ2V4LmV4ZWMoc3RyaW5nKTsJCgl9CglpZiAoISBzdHJpbmcgPT0gJycpCgl7CgkJcmV0QXJyLnB1c2goc3RyaW5nKTsKCX0KCXJldHVybiByZXRBcnI7Cn0sCmNob3AgPSAgZnVuY3Rpb24oc3RyaW5nKXsKICAgIHJldHVybiBzdHJpbmcuc3Vic3RyKDAsIHN0cmluZy5sZW5ndGggLSAxKTsKfSwKZXh0ZW5kID0gZnVuY3Rpb24oZCwgcyl7CiAgICBmb3IodmFyIG4gaW4gcyl7CiAgICAgICAgaWYocy5oYXNPd25Qcm9wZXJ0eShuKSkgIGRbbl0gPSBzW25dCiAgICB9Cn0KCgpFSlMgPSBmdW5jdGlvbiggb3B0aW9ucyApewoJb3B0aW9ucyA9IHR5cGVvZiBvcHRpb25zID09ICJzdHJpbmciID8ge3ZpZXc6IG9wdGlvbnN9IDogb3B0aW9ucwogICAgdGhpcy5zZXRfb3B0aW9ucyhvcHRpb25zKTsKCWlmKG9wdGlvbnMucHJlY29tcGlsZWQpewoJCXRoaXMudGVtcGxhdGUgPSB7fTsKCQl0aGlzLnRlbXBsYXRlLnByb2Nlc3MgPSBvcHRpb25zLnByZWNvbXBpbGVkOwoJCUVKUy51cGRhdGUodGhpcy5uYW1lLCB0aGlzKTsKCQlyZXR1cm47Cgl9CiAgICBpZihvcHRpb25zLmVsZW1lbnQpCgl7CgkJaWYodHlwZW9mIG9wdGlvbnMuZWxlbWVudCA9PSAnc3RyaW5nJyl7CgkJCXZhciBuYW1lID0gb3B0aW9ucy5lbGVtZW50CgkJCW9wdGlvbnMuZWxlbWVudCA9IGRvY3VtZW50LmdldEVsZW1lbnRCeUlkKCAgb3B0aW9ucy5lbGVtZW50ICkKCQkJaWYob3B0aW9ucy5lbGVtZW50ID09IG51bGwpIHRocm93IG5hbWUrJ2RvZXMgbm90IGV4aXN0IScKCQl9CgkJaWYob3B0aW9ucy5lbGVtZW50LnZhbHVlKXsKCQkJdGhpcy50ZXh0ID0gb3B0aW9ucy5lbGVtZW50LnZhbHVlCgkJfWVsc2V7CgkJCXRoaXMudGV4dCA9IG9wdGlvbnMuZWxlbWVudC5pbm5lckhUTUwKCQl9CgkJdGhpcy5uYW1lID0gb3B0aW9ucy5lbGVtZW50LmlkCgkJdGhpcy50eXBlID0gJ1snCgl9ZWxzZSBpZihvcHRpb25zLnVybCl7CiAgICAgICAgb3B0aW9ucy51cmwgPSBFSlMuZW5kRXh0KG9wdGlvbnMudXJsLCB0aGlzLmV4dE1hdGNoKTsKCQl0aGlzLm5hbWUgPSB0aGlzLm5hbWUgPyB0aGlzLm5hbWUgOiBvcHRpb25zLnVybDsKICAgICAgICB2YXIgdXJsID0gb3B0aW9ucy51cmwKICAgICAgICAvL29wdGlvbnMudmlldyA9IG9wdGlvbnMuYWJzb2x1dGVfdXJsIHx8IG9wdGlvbnMudmlldyB8fCBvcHRpb25zLjsKCQl2YXIgdGVtcGxhdGUgPSBFSlMuZ2V0KHRoaXMubmFtZSAvKnVybCovLCB0aGlzLmNhY2hlKTsKCQlpZiAodGVtcGxhdGUpIHJldHVybiB0ZW1wbGF0ZTsKCSAgICBpZiAodGVtcGxhdGUgPT0gRUpTLklOVkFMSURfUEFUSCkgcmV0dXJuIG51bGw7CiAgICAgICAgdHJ5ewogICAgICAgICAgICB0aGlzLnRleHQgPSBFSlMucmVxdWVzdCggdXJsKyh0aGlzLmNhY2hlID8gJycgOiAnPycrTWF0aC5yYW5kb20oKSApKTsKICAgICAgICB9Y2F0Y2goZSl7fQoKCQlpZih0aGlzLnRleHQgPT0gbnVsbCl7CiAgICAgICAgICAgIHRocm93KCB7dHlwZTogJ0VKUycsIG1lc3NhZ2U6ICdUaGVyZSBpcyBubyB0ZW1wbGF0ZSBhdCAnK3VybH0gICk7CgkJfQoJCS8vdGhpcy5uYW1lID0gdXJsOwoJfQoJdmFyIHRlbXBsYXRlID0gbmV3IEVKUy5Db21waWxlcih0aGlzLnRleHQsIHRoaXMudHlwZSk7CgoJdGVtcGxhdGUuY29tcGlsZShvcHRpb25zLCB0aGlzLm5hbWUpOwoKCQoJRUpTLnVwZGF0ZSh0aGlzLm5hbWUsIHRoaXMpOwoJdGhpcy50ZW1wbGF0ZSA9IHRlbXBsYXRlOwp9OwovKiBAUHJvdG90eXBlKi8KRUpTLnByb3RvdHlwZSA9IHsKCS8qKgoJICogUmVuZGVycyBhbiBvYmplY3Qgd2l0aCBleHRyYSB2aWV3IGhlbHBlcnMgYXR0YWNoZWQgdG8gdGhlIHZpZXcuCgkgKiBAcGFyYW0ge09iamVjdH0gb2JqZWN0IGRhdGEgdG8gYmUgcmVuZGVyZWQKCSAqIEBwYXJhbSB7T2JqZWN0fSBleHRyYV9oZWxwZXJzIGFuIG9iamVjdCB3aXRoIGFkZGl0b25hbCB2aWV3IGhlbHBlcnMKCSAqIEByZXR1cm4ge1N0cmluZ30gcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSBzdHJpbmcKCSAqLwogICAgcmVuZGVyIDogZnVuY3Rpb24ob2JqZWN0LCBleHRyYV9oZWxwZXJzKXsKICAgICAgICBvYmplY3QgPSBvYmplY3QgfHwge307CiAgICAgICAgdGhpcy5fZXh0cmFfaGVscGVycyA9IGV4dHJhX2hlbHBlcnM7CgkJdmFyIHYgPSBuZXcgRUpTLkhlbHBlcnMob2JqZWN0LCBleHRyYV9oZWxwZXJzIHx8IHt9KTsKCQlyZXR1cm4gdGhpcy50ZW1wbGF0ZS5wcm9jZXNzLmNhbGwob2JqZWN0LCBvYmplY3Qsdik7Cgl9LAogICAgdXBkYXRlIDogZnVuY3Rpb24oZWxlbWVudCwgb3B0aW9ucyl7CiAgICAgICAgaWYodHlwZW9mIGVsZW1lbnQgPT0gJ3N0cmluZycpewoJCQllbGVtZW50ID0gZG9jdW1lbnQuZ2V0RWxlbWVudEJ5SWQoZWxlbWVudCkKCQl9CgkJaWYob3B0aW9ucyA9PSBudWxsKXsKCQkJX3RlbXBsYXRlID0gdGhpczsKCQkJcmV0dXJuIGZ1bmN0aW9uKG9iamVjdCl7CgkJCQlFSlMucHJvdG90eXBlLnVwZGF0ZS5jYWxsKF90ZW1wbGF0ZSwgZWxlbWVudCwgb2JqZWN0KQoJCQl9CgkJfQoJCWlmKHR5cGVvZiBvcHRpb25zID09ICdzdHJpbmcnKXsKCQkJcGFyYW1zID0ge30KCQkJcGFyYW1zLnVybCA9IG9wdGlvbnMKCQkJX3RlbXBsYXRlID0gdGhpczsKCQkJcGFyYW1zLm9uQ29tcGxldGUgPSBmdW5jdGlvbihyZXF1ZXN0KXsKCQkJCXZhciBvYmplY3QgPSBldmFsKCByZXF1ZXN0LnJlc3BvbnNlVGV4dCApCgkJCQlFSlMucHJvdG90eXBlLnVwZGF0ZS5jYWxsKF90ZW1wbGF0ZSwgZWxlbWVudCwgb2JqZWN0KQoJCQl9CgkJCUVKUy5hamF4X3JlcXVlc3QocGFyYW1zKQoJCX1lbHNlCgkJewoJCQllbGVtZW50LmlubmVySFRNTCA9IHRoaXMucmVuZGVyKG9wdGlvbnMpCgkJfQogICAgfSwKCW91dCA6IGZ1bmN0aW9uKCl7CgkJcmV0dXJuIHRoaXMudGVtcGxhdGUub3V0OwoJfSwKICAgIC8qKgogICAgICogU2V0cyBvcHRpb25zIG9uIHRoaXMgdmlldyB0byBiZSByZW5kZXJlZCB3aXRoLgogICAgICogQHBhcmFtIHtPYmplY3R9IG9wdGlvbnMKICAgICAqLwoJc2V0X29wdGlvbnMgOiBmdW5jdGlvbihvcHRpb25zKXsKICAgICAgICB0aGlzLnR5cGUgPSBvcHRpb25zLnR5cGUgfHwgRUpTLnR5cGU7CgkJdGhpcy5jYWNoZSA9IG9wdGlvbnMuY2FjaGUgIT0gbnVsbCA/IG9wdGlvbnMuY2FjaGUgOiBFSlMuY2FjaGU7CgkJdGhpcy50ZXh0ID0gb3B0aW9ucy50ZXh0IHx8IG51bGw7CgkJdGhpcy5uYW1lID0gIG9wdGlvbnMubmFtZSB8fCBudWxsOwoJCXRoaXMuZXh0ID0gb3B0aW9ucy5leHQgfHwgRUpTLmV4dDsKCQl0aGlzLmV4dE1hdGNoID0gbmV3IFJlZ0V4cCh0aGlzLmV4dC5yZXBsYWNlKC9cLi8sICdcLicpKTsKCX0KfTsKRUpTLmVuZEV4dCA9IGZ1bmN0aW9uKHBhdGgsIG1hdGNoKXsKCWlmKCFwYXRoKSByZXR1cm4gbnVsbDsKCW1hdGNoLmxhc3RJbmRleCA9IDAKCXJldHVybiBwYXRoKyAobWF0Y2gudGVzdChwYXRoKSA/ICcnIDogdGhpcy5leHQgKQp9CgoKCgovKiBAU3RhdGljKi8KRUpTLlNjYW5uZXIgPSBmdW5jdGlvbihzb3VyY2UsIGxlZnQsIHJpZ2h0KSB7CgkKICAgIGV4dGVuZCh0aGlzLAogICAgICAgIHtsZWZ0X2RlbGltaXRlcjogCWxlZnQgKyclJywKICAgICAgICAgcmlnaHRfZGVsaW1pdGVyOiAJJyUnK3JpZ2h0LAogICAgICAgICBkb3VibGVfbGVmdDogCQlsZWZ0KyclJScsCiAgICAgICAgIGRvdWJsZV9yaWdodDogIAknJSUnK3JpZ2h0LAogICAgICAgICBsZWZ0X2VxdWFsOiAJCWxlZnQrJyU9JywKICAgICAgICAgbGVmdF9jb21tZW50OiAJbGVmdCsnJSMnfSkKCgl0aGlzLlNwbGl0UmVnZXhwID0gbGVmdD09J1snID8gLyhcWyUlKXwoJSVcXSl8KFxbJT0pfChcWyUjKXwoXFslKXwoJVxdXG4pfCglXF0pfChcbikvIDogbmV3IFJlZ0V4cCgnKCcrdGhpcy5kb3VibGVfbGVmdCsnKXwoJSUnK3RoaXMuZG91YmxlX3JpZ2h0KycpfCgnK3RoaXMubGVmdF9lcXVhbCsnKXwoJyt0aGlzLmxlZnRfY29tbWVudCsnKXwoJyt0aGlzLmxlZnRfZGVsaW1pdGVyKycpfCgnK3RoaXMucmlnaHRfZGVsaW1pdGVyKydcbil8KCcrdGhpcy5yaWdodF9kZWxpbWl0ZXIrJyl8KFxuKScpIDsKCQoJdGhpcy5zb3VyY2UgPSBzb3VyY2U7Cgl0aGlzLnN0YWcgPSBudWxsOwoJdGhpcy5saW5lcyA9IDA7Cn07CgpFSlMuU2Nhbm5lci50b190ZXh0ID0gZnVuY3Rpb24oaW5wdXQpewoJaWYoaW5wdXQgPT0gbnVsbCB8fCBpbnB1dCA9PT0gdW5kZWZpbmVkKQogICAgICAgIHJldHVybiAnJzsKICAgIGlmKGlucHV0IGluc3RhbmNlb2YgRGF0ZSkKCQlyZXR1cm4gaW5wdXQudG9EYXRlU3RyaW5nKCk7CglpZihpbnB1dC50b1N0cmluZykgCiAgICAgICAgcmV0dXJuIGlucHV0LnRvU3RyaW5nKCk7CglyZXR1cm4gJyc7Cn07CgpFSlMuU2Nhbm5lci5wcm90b3R5cGUgPSB7CiAgc2NhbjogZnVuY3Rpb24oYmxvY2spIHsKICAgICBzY2FubGluZSA9IHRoaXMuc2NhbmxpbmU7CgkgcmVnZXggPSB0aGlzLlNwbGl0UmVnZXhwOwoJIGlmICghIHRoaXMuc291cmNlID09ICcnKQoJIHsKCSAJIHZhciBzb3VyY2Vfc3BsaXQgPSByc3BsaXQodGhpcy5zb3VyY2UsIC9cbi8pOwoJIAkgZm9yKHZhciBpPTA7IGk8c291cmNlX3NwbGl0Lmxlbmd0aDsgaSsrKSB7CgkJIAkgdmFyIGl0ZW0gPSBzb3VyY2Vfc3BsaXRbaV07CgkJCSB0aGlzLnNjYW5saW5lKGl0ZW0sIHJlZ2V4LCBibG9jayk7CgkJIH0KCSB9CiAgfSwKICBzY2FubGluZTogZnVuY3Rpb24obGluZSwgcmVnZXgsIGJsb2NrKSB7CgkgdGhpcy5saW5lcysrOwoJIHZhciBsaW5lX3NwbGl0ID0gcnNwbGl0KGxpbmUsIHJlZ2V4KTsKIAkgZm9yKHZhciBpPTA7IGk8bGluZV9zcGxpdC5sZW5ndGg7IGkrKykgewoJICAgdmFyIHRva2VuID0gbGluZV9zcGxpdFtpXTsKICAgICAgIGlmICh0b2tlbiAhPSBudWxsKSB7CgkJICAgCXRyeXsKCSAgICAgICAgIAlibG9jayh0b2tlbiwgdGhpcyk7CgkJIAl9Y2F0Y2goZSl7CgkJCQl0aHJvdyB7dHlwZTogJ0VKUy5TY2FubmVyJywgbGluZTogdGhpcy5saW5lc307CgkJCX0KICAgICAgIH0KCSB9CiAgfQp9OwoKCkVKUy5CdWZmZXIgPSBmdW5jdGlvbihwcmVfY21kLCBwb3N0X2NtZCkgewoJdGhpcy5saW5lID0gbmV3IEFycmF5KCk7Cgl0aGlzLnNjcmlwdCA9ICIiOwoJdGhpcy5wcmVfY21kID0gcHJlX2NtZDsKCXRoaXMucG9zdF9jbWQgPSBwb3N0X2NtZDsKCWZvciAodmFyIGk9MDsgaTx0aGlzLnByZV9jbWQubGVuZ3RoOyBpKyspCgl7CgkJdGhpcy5wdXNoKHByZV9jbWRbaV0pOwoJfQp9OwpFSlMuQnVmZmVyLnByb3RvdHlwZSA9IHsKCQogIHB1c2g6IGZ1bmN0aW9uKGNtZCkgewoJdGhpcy5saW5lLnB1c2goY21kKTsKICB9LAoKICBjcjogZnVuY3Rpb24oKSB7Cgl0aGlzLnNjcmlwdCA9IHRoaXMuc2NyaXB0ICsgdGhpcy5saW5lLmpvaW4oJzsgJyk7Cgl0aGlzLmxpbmUgPSBuZXcgQXJyYXkoKTsKCXRoaXMuc2NyaXB0ID0gdGhpcy5zY3JpcHQgKyAiXG4iOwogIH0sCgogIGNsb3NlOiBmdW5jdGlvbigpIHsKCWlmICh0aGlzLmxpbmUubGVuZ3RoID4gMCkKCXsKCQlmb3IgKHZhciBpPTA7IGk8dGhpcy5wb3N0X2NtZC5sZW5ndGg7IGkrKyl7CgkJCXRoaXMucHVzaChwcmVfY21kW2ldKTsKCQl9CgkJdGhpcy5zY3JpcHQgPSB0aGlzLnNjcmlwdCArIHRoaXMubGluZS5qb2luKCc7ICcpOwoJCWxpbmUgPSBudWxsOwoJfQogIH0KIAkKfTsKCgpFSlMuQ29tcGlsZXIgPSBmdW5jdGlvbihzb3VyY2UsIGxlZnQpIHsKICAgIHRoaXMucHJlX2NtZCA9IFsndmFyIF9fX1ZpZXdPID0gW107J107Cgl0aGlzLnBvc3RfY21kID0gbmV3IEFycmF5KCk7Cgl0aGlzLnNvdXJjZSA9ICcgJzsJCglpZiAoc291cmNlICE9IG51bGwpCgl7CgkJaWYgKHR5cGVvZiBzb3VyY2UgPT0gJ3N0cmluZycpCgkJewoJCSAgICBzb3VyY2UgPSBzb3VyY2UucmVwbGFjZSgvXHJcbi9nLCAiXG4iKTsKICAgICAgICAgICAgc291cmNlID0gc291cmNlLnJlcGxhY2UoL1xyL2csICAgIlxuIik7CgkJCXRoaXMuc291cmNlID0gc291cmNlOwoJCX1lbHNlIGlmIChzb3VyY2UuaW5uZXJIVE1MKXsKCQkJdGhpcy5zb3VyY2UgPSBzb3VyY2UuaW5uZXJIVE1MOwoJCX0gCgkJaWYgKHR5cGVvZiB0aGlzLnNvdXJjZSAhPSAnc3RyaW5nJyl7CgkJCXRoaXMuc291cmNlID0gIiI7CgkJfQoJfQoJbGVmdCA9IGxlZnQgfHwgJzwnOwoJdmFyIHJpZ2h0ID0gJz4nOwoJc3dpdGNoKGxlZnQpIHsKCQljYXNlICdbJzoKCQkJcmlnaHQgPSAnXSc7CgkJCWJyZWFrOwoJCWNhc2UgJzwnOgoJCQlicmVhazsKCQlkZWZhdWx0OgoJCQl0aHJvdyBsZWZ0KycgaXMgbm90IGEgc3VwcG9ydGVkIGRlbGltaW5hdG9yJzsKCQkJYnJlYWs7Cgl9Cgl0aGlzLnNjYW5uZXIgPSBuZXcgRUpTLlNjYW5uZXIodGhpcy5zb3VyY2UsIGxlZnQsIHJpZ2h0KTsKCXRoaXMub3V0ID0gJyc7Cn07CkVKUy5Db21waWxlci5wcm90b3R5cGUgPSB7CiAgY29tcGlsZTogZnVuY3Rpb24ob3B0aW9ucywgbmFtZSkgewogIAlvcHRpb25zID0gb3B0aW9ucyB8fCB7fTsKCXRoaXMub3V0ID0gJyc7Cgl2YXIgcHV0X2NtZCA9ICJfX19WaWV3Ty5wdXNoKCI7Cgl2YXIgaW5zZXJ0X2NtZCA9IHB1dF9jbWQ7Cgl2YXIgYnVmZiA9IG5ldyBFSlMuQnVmZmVyKHRoaXMucHJlX2NtZCwgdGhpcy5wb3N0X2NtZCk7CQkKCXZhciBjb250ZW50ID0gJyc7Cgl2YXIgY2xlYW4gPSBmdW5jdGlvbihjb250ZW50KQoJewoJICAgIGNvbnRlbnQgPSBjb250ZW50LnJlcGxhY2UoL1xcL2csICdcXFxcJyk7CiAgICAgICAgY29udGVudCA9IGNvbnRlbnQucmVwbGFjZSgvXG4vZywgJ1xcbicpOwogICAgICAgIGNvbnRlbnQgPSBjb250ZW50LnJlcGxhY2UoLyIvZywgICdcXCInKTsKICAgICAgICByZXR1cm4gY29udGVudDsKCX07Cgl0aGlzLnNjYW5uZXIuc2NhbihmdW5jdGlvbih0b2tlbiwgc2Nhbm5lcikgewoJCWlmIChzY2FubmVyLnN0YWcgPT0gbnVsbCkKCQl7CgkJCXN3aXRjaCh0b2tlbikgewoJCQkJY2FzZSAnXG4nOgoJCQkJCWNvbnRlbnQgPSBjb250ZW50ICsgIlxuIjsKCQkJCQlidWZmLnB1c2gocHV0X2NtZCArICciJyArIGNsZWFuKGNvbnRlbnQpICsgJyIpOycpOwoJCQkJCWJ1ZmYuY3IoKTsKCQkJCQljb250ZW50ID0gJyc7CgkJCQkJYnJlYWs7CgkJCQljYXNlIHNjYW5uZXIubGVmdF9kZWxpbWl0ZXI6CgkJCQljYXNlIHNjYW5uZXIubGVmdF9lcXVhbDoKCQkJCWNhc2Ugc2Nhbm5lci5sZWZ0X2NvbW1lbnQ6CgkJCQkJc2Nhbm5lci5zdGFnID0gdG9rZW47CgkJCQkJaWYgKGNvbnRlbnQubGVuZ3RoID4gMCkKCQkJCQl7CgkJCQkJCWJ1ZmYucHVzaChwdXRfY21kICsgJyInICsgY2xlYW4oY29udGVudCkgKyAnIiknKTsKCQkJCQl9CgkJCQkJY29udGVudCA9ICcnOwoJCQkJCWJyZWFrOwoJCQkJY2FzZSBzY2FubmVyLmRvdWJsZV9sZWZ0OgoJCQkJCWNvbnRlbnQgPSBjb250ZW50ICsgc2Nhbm5lci5sZWZ0X2RlbGltaXRlcjsKCQkJCQlicmVhazsKCQkJCWRlZmF1bHQ6CgkJCQkJY29udGVudCA9IGNvbnRlbnQgKyB0b2tlbjsKCQkJCQlicmVhazsKCQkJfQoJCX0KCQllbHNlIHsKCQkJc3dpdGNoKHRva2VuKSB7CgkJCQljYXNlIHNjYW5uZXIucmlnaHRfZGVsaW1pdGVyOgoJCQkJCXN3aXRjaChzY2FubmVyLnN0YWcpIHsKCQkJCQkJY2FzZSBzY2FubmVyLmxlZnRfZGVsaW1pdGVyOgoJCQkJCQkJaWYgKGNvbnRlbnRbY29udGVudC5sZW5ndGggLSAxXSA9PSAnXG4nKQoJCQkJCQkJewoJCQkJCQkJCWNvbnRlbnQgPSBjaG9wKGNvbnRlbnQpOwoJCQkJCQkJCWJ1ZmYucHVzaChjb250ZW50KTsKCQkJCQkJCQlidWZmLmNyKCk7CgkJCQkJCQl9CgkJCQkJCQllbHNlIHsKCQkJCQkJCQlidWZmLnB1c2goY29udGVudCk7CgkJCQkJCQl9CgkJCQkJCQlicmVhazsKCQkJCQkJY2FzZSBzY2FubmVyLmxlZnRfZXF1YWw6CgkJCQkJCQlidWZmLnB1c2goaW5zZXJ0X2NtZCArICIoRUpTLlNjYW5uZXIudG9fdGV4dCgiICsgY29udGVudCArICIpKSkiKTsKCQkJCQkJCWJyZWFrOwoJCQkJCX0KCQkJCQlzY2FubmVyLnN0YWcgPSBudWxsOwoJCQkJCWNvbnRlbnQgPSAnJzsKCQkJCQlicmVhazsKCQkJCWNhc2Ugc2Nhbm5lci5kb3VibGVfcmlnaHQ6CgkJCQkJY29udGVudCA9IGNvbnRlbnQgKyBzY2FubmVyLnJpZ2h0X2RlbGltaXRlcjsKCQkJCQlicmVhazsKCQkJCWRlZmF1bHQ6CgkJCQkJY29udGVudCA9IGNvbnRlbnQgKyB0b2tlbjsKCQkJCQlicmVhazsKCQkJfQoJCX0KCX0pOwoJaWYgKGNvbnRlbnQubGVuZ3RoID4gMCkKCXsKCQkvLyBDaG91bGQgYmUgY29udGVudC5kdW1wIGluIFJ1YnkKCQlidWZmLnB1c2gocHV0X2NtZCArICciJyArIGNsZWFuKGNvbnRlbnQpICsgJyIpJyk7Cgl9CglidWZmLmNsb3NlKCk7Cgl0aGlzLm91dCA9IGJ1ZmYuc2NyaXB0ICsgIjsiOwoJdmFyIHRvX2JlX2V2YWxlZCA9ICcvKicrbmFtZSsnKi90aGlzLnByb2Nlc3MgPSBmdW5jdGlvbihfQ09OVEVYVCxfVklFVykgeyB0cnkgeyB3aXRoKF9WSUVXKSB7IHdpdGggKF9DT05URVhUKSB7Jyt0aGlzLm91dCsiIHJldHVybiBfX19WaWV3Ty5qb2luKCcnKTt9fX1jYXRjaChlKXtlLmxpbmVOdW1iZXI9bnVsbDt0aHJvdyBlO319OyI7CgkKCXRyeXsKCQlldmFsKHRvX2JlX2V2YWxlZCk7Cgl9Y2F0Y2goZSl7CgkJaWYodHlwZW9mIEpTTElOVCAhPSAndW5kZWZpbmVkJyl7CgkJCUpTTElOVCh0aGlzLm91dCk7CgkJCWZvcih2YXIgaSA9IDA7IGkgPCBKU0xJTlQuZXJyb3JzLmxlbmd0aDsgaSsrKXsKCQkJCXZhciBlcnJvciA9IEpTTElOVC5lcnJvcnNbaV07CgkJCQlpZihlcnJvci5yZWFzb24gIT0gIlVubmVjZXNzYXJ5IHNlbWljb2xvbi4iKXsKCQkJCQllcnJvci5saW5lKys7CgkJCQkJdmFyIGUgPSBuZXcgRXJyb3IoKTsKCQkJCQllLmxpbmVOdW1iZXIgPSBlcnJvci5saW5lOwoJCQkJCWUubWVzc2FnZSA9IGVycm9yLnJlYXNvbjsKCQkJCQlpZihvcHRpb25zLnZpZXcpCgkJCQkJCWUuZmlsZU5hbWUgPSBvcHRpb25zLnZpZXc7CgkJCQkJdGhyb3cgZTsKCQkJCX0KCQkJfQoJCX1lbHNlewoJCQl0aHJvdyBlOwoJCX0KCX0KICB9Cn07CgoKLy90eXBlLCBjYWNoZSwgZm9sZGVyCi8qKgogKiBTZXRzIGRlZmF1bHQgb3B0aW9ucyBmb3IgYWxsIHZpZXdzCiAqIEBwYXJhbSB7T2JqZWN0fSBvcHRpb25zIFNldCB2aWV3IHdpdGggdGhlIGZvbGxvd2luZyBvcHRpb25zCiAqIDx0YWJsZSBjbGFzcz0ib3B0aW9ucyI+CgkJCQk8dGJvZHk+PHRyPjx0aD5PcHRpb248L3RoPjx0aD5EZWZhdWx0PC90aD48dGg+RGVzY3JpcHRpb248L3RoPjwvdHI+CgkJCQk8dHI+CgkJCQkJPHRkPnR5cGU8L3RkPgoJCQkJCTx0ZD4nPCc8L3RkPgoJCQkJCTx0ZD50eXBlIG9mIG1hZ2ljIHRhZ3MuICBPcHRpb25zIGFyZSAnJmx0Oycgb3IgJ1snCgkJCQkJPC90ZD4KCQkJCTwvdHI+CgkJCQk8dHI+CgkJCQkJPHRkPmNhY2hlPC90ZD4KCQkJCQk8dGQ+dHJ1ZSBpbiBwcm9kdWN0aW9uIG1vZGUsIGZhbHNlIGluIG90aGVyIG1vZGVzPC90ZD4KCQkJCQk8dGQ+dHJ1ZSB0byBjYWNoZSB0ZW1wbGF0ZS4KCQkJCQk8L3RkPgoJCQkJPC90cj4KCTwvdGJvZHk+PC90YWJsZT4KICogCiAqLwpFSlMuY29uZmlnID0gZnVuY3Rpb24ob3B0aW9ucyl7CglFSlMuY2FjaGUgPSBvcHRpb25zLmNhY2hlICE9IG51bGwgPyBvcHRpb25zLmNhY2hlIDogRUpTLmNhY2hlOwoJRUpTLnR5cGUgPSBvcHRpb25zLnR5cGUgIT0gbnVsbCA/IG9wdGlvbnMudHlwZSA6IEVKUy50eXBlOwoJRUpTLmV4dCA9IG9wdGlvbnMuZXh0ICE9IG51bGwgPyBvcHRpb25zLmV4dCA6IEVKUy5leHQ7CgkKCXZhciB0ZW1wbGF0ZXNfZGlyZWN0b3J5ID0gRUpTLnRlbXBsYXRlc19kaXJlY3RvcnkgfHwge307IC8vbmljZSBhbmQgcHJpdmF0ZSBjb250YWluZXIKCUVKUy50ZW1wbGF0ZXNfZGlyZWN0b3J5ID0gdGVtcGxhdGVzX2RpcmVjdG9yeTsKCUVKUy5nZXQgPSBmdW5jdGlvbihwYXRoLCBjYWNoZSl7CgkJaWYoY2FjaGUgPT0gZmFsc2UpIHJldHVybiBudWxsOwoJCWlmKHRlbXBsYXRlc19kaXJlY3RvcnlbcGF0aF0pIHJldHVybiB0ZW1wbGF0ZXNfZGlyZWN0b3J5W3BhdGhdOwogIAkJcmV0dXJuIG51bGw7Cgl9OwoJCglFSlMudXBkYXRlID0gZnVuY3Rpb24ocGF0aCwgdGVtcGxhdGUpIHsgCgkJaWYocGF0aCA9PSBudWxsKSByZXR1cm47CgkJdGVtcGxhdGVzX2RpcmVjdG9yeVtwYXRoXSA9IHRlbXBsYXRlIDsKCX07CgkKCUVKUy5JTlZBTElEX1BBVEggPSAgLTE7Cn07CkVKUy5jb25maWcoIHtjYWNoZTogdHJ1ZSwgdHlwZTogJzwnLCBleHQ6ICcuaHRtJyB9ICk7CgoKCi8qKgogKiBAY29uc3RydWN0b3IKICogQnkgYWRkaW5nIGZ1bmN0aW9ucyB0byBFSlMuSGVscGVycy5wcm90b3R5cGUsIHRob3NlIGZ1bmN0aW9ucyB3aWxsIGJlIGF2YWlsYWJsZSBpbiB0aGUgCiAqIHZpZXdzLgogKiBAaW5pdCBDcmVhdGVzIGEgdmlldyBoZWxwZXIuICBUaGlzIGZ1bmN0aW9uIGlzIGNhbGxlZCBpbnRlcm5hbGx5LiAgWW91IHNob3VsZCBuZXZlciBjYWxsIGl0LgogKiBAcGFyYW0ge09iamVjdH0gZGF0YSBUaGUgZGF0YSBwYXNzZWQgdG8gdGhlIHZpZXcuICBIZWxwZXJzIGhhdmUgYWNjZXNzIHRvIGl0IHRocm91Z2ggdGhpcy5fZGF0YQogKi8KRUpTLkhlbHBlcnMgPSBmdW5jdGlvbihkYXRhLCBleHRyYXMpewoJdGhpcy5fZGF0YSA9IGRhdGE7CiAgICB0aGlzLl9leHRyYXMgPSBleHRyYXM7CiAgICBleHRlbmQodGhpcywgZXh0cmFzICk7Cn07Ci8qIEBwcm90b3R5cGUqLwpFSlMuSGVscGVycy5wcm90b3R5cGUgPSB7CiAgICAvKioKICAgICAqIFJlbmRlcnMgYSBuZXcgdmlldy4gIElmIGRhdGEgaXMgcGFzc2VkIGluLCB1c2VzIHRoYXQgdG8gcmVuZGVyIHRoZSB2aWV3LgogICAgICogQHBhcmFtIHtPYmplY3R9IG9wdGlvbnMgc3RhbmRhcmQgb3B0aW9ucyBwYXNzZWQgdG8gYSBuZXcgdmlldy4KICAgICAqIEBwYXJhbSB7b3B0aW9uYWw6T2JqZWN0fSBkYXRhCiAgICAgKiBAcmV0dXJuIHtTdHJpbmd9CiAgICAgKi8KCXZpZXc6IGZ1bmN0aW9uKG9wdGlvbnMsIGRhdGEsIGhlbHBlcnMpewogICAgICAgIGlmKCFoZWxwZXJzKSBoZWxwZXJzID0gdGhpcy5fZXh0cmFzCgkJaWYoIWRhdGEpIGRhdGEgPSB0aGlzLl9kYXRhOwoJCXJldHVybiBuZXcgRUpTKG9wdGlvbnMpLnJlbmRlcihkYXRhLCBoZWxwZXJzKTsKCX0sCiAgICAvKioKICAgICAqIEZvciBhIGdpdmVuIHZhbHVlLCB0cmllcyB0byBjcmVhdGUgYSBodW1hbiByZXByZXNlbnRhdGlvbi4KICAgICAqIEBwYXJhbSB7T2JqZWN0fSBpbnB1dCB0aGUgdmFsdWUgYmVpbmcgY29udmVydGVkLgogICAgICogQHBhcmFtIHtPYmplY3R9IG51bGxfdGV4dCB3aGF0IHRleHQgc2hvdWxkIGJlIHByZXNlbnQgaWYgaW5wdXQgPT0gbnVsbCBvciB1bmRlZmluZWQsIGRlZmF1bHRzIHRvICcnCiAgICAgKiBAcmV0dXJuIHtTdHJpbmd9IAogICAgICovCgl0b190ZXh0OiBmdW5jdGlvbihpbnB1dCwgbnVsbF90ZXh0KSB7CgkgICAgaWYoaW5wdXQgPT0gbnVsbCB8fCBpbnB1dCA9PT0gdW5kZWZpbmVkKSByZXR1cm4gbnVsbF90ZXh0IHx8ICcnOwoJICAgIGlmKGlucHV0IGluc3RhbmNlb2YgRGF0ZSkgcmV0dXJuIGlucHV0LnRvRGF0ZVN0cmluZygpOwoJCWlmKGlucHV0LnRvU3RyaW5nKSByZXR1cm4gaW5wdXQudG9TdHJpbmcoKS5yZXBsYWNlKC9cbi9nLCAnPGJyIC8+JykucmVwbGFjZSgvJycvZywgIiciKTsKCQlyZXR1cm4gJyc7Cgl9Cn07CiAgICBFSlMubmV3UmVxdWVzdCA9IGZ1bmN0aW9uKCl7CgkgICB2YXIgZmFjdG9yaWVzID0gW2Z1bmN0aW9uKCkgeyByZXR1cm4gbmV3IEFjdGl2ZVhPYmplY3QoIk1zeG1sMi5YTUxIVFRQIik7IH0sZnVuY3Rpb24oKSB7IHJldHVybiBuZXcgWE1MSHR0cFJlcXVlc3QoKTsgfSxmdW5jdGlvbigpIHsgcmV0dXJuIG5ldyBBY3RpdmVYT2JqZWN0KCJNaWNyb3NvZnQuWE1MSFRUUCIpOyB9XTsKCSAgIGZvcih2YXIgaSA9IDA7IGkgPCBmYWN0b3JpZXMubGVuZ3RoOyBpKyspIHsKCSAgICAgICAgdHJ5IHsKCSAgICAgICAgICAgIHZhciByZXF1ZXN0ID0gZmFjdG9yaWVzW2ldKCk7CgkgICAgICAgICAgICBpZiAocmVxdWVzdCAhPSBudWxsKSAgcmV0dXJuIHJlcXVlc3Q7CgkgICAgICAgIH0KCSAgICAgICAgY2F0Y2goZSkgeyBjb250aW51ZTt9CgkgICB9Cgl9CgkKCUVKUy5yZXF1ZXN0ID0gZnVuY3Rpb24ocGF0aCl7CgkgICB2YXIgcmVxdWVzdCA9IG5ldyBFSlMubmV3UmVxdWVzdCgpCgkgICByZXF1ZXN0Lm9wZW4oIkdFVCIsIHBhdGgsIGZhbHNlKTsKCSAgIAoJICAgdHJ5e3JlcXVlc3Quc2VuZChudWxsKTt9CgkgICBjYXRjaChlKXtyZXR1cm4gbnVsbDt9CgkgICAKCSAgIGlmICggcmVxdWVzdC5zdGF0dXMgPT0gNDA0IHx8IHJlcXVlc3Quc3RhdHVzID09IDIgfHwocmVxdWVzdC5zdGF0dXMgPT0gMCAmJiByZXF1ZXN0LnJlc3BvbnNlVGV4dCA9PSAnJykgKSByZXR1cm4gbnVsbDsKCSAgIAoJICAgcmV0dXJuIHJlcXVlc3QucmVzcG9uc2VUZXh0Cgl9CglFSlMuYWpheF9yZXF1ZXN0ID0gZnVuY3Rpb24ocGFyYW1zKXsKCQlwYXJhbXMubWV0aG9kID0gKCBwYXJhbXMubWV0aG9kID8gcGFyYW1zLm1ldGhvZCA6ICdHRVQnKQoJCQoJCXZhciByZXF1ZXN0ID0gbmV3IEVKUy5uZXdSZXF1ZXN0KCk7CgkJcmVxdWVzdC5vbnJlYWR5c3RhdGVjaGFuZ2UgPSBmdW5jdGlvbigpewoJCQlpZihyZXF1ZXN0LnJlYWR5U3RhdGUgPT0gNCl7CgkJCQlpZihyZXF1ZXN0LnN0YXR1cyA9PSAyMDApewoJCQkJCXBhcmFtcy5vbkNvbXBsZXRlKHJlcXVlc3QpCgkJCQl9ZWxzZQoJCQkJewoJCQkJCXBhcmFtcy5vbkNvbXBsZXRlKHJlcXVlc3QpCgkJCQl9CgkJCX0KCQl9CgkJcmVxdWVzdC5vcGVuKHBhcmFtcy5tZXRob2QsIHBhcmFtcy51cmwpCgkJcmVxdWVzdC5zZW5kKG51bGwpCgl9CgoKfSkoKTs=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/ejs.js,importbuddy/js/ejs.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/importbuddy.js,importbuddy/js/importbuddy.js
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/importbuddy.js,importbuddy/js/importbuddy.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/index.php,importbuddy/js/index.php
PD9waHAgLy8gU2lsZW5jZSBpcyBnb2xkZW4u
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/index.php,importbuddy/js/index.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/jquery.js,importbuddy/js/jquery.js
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/jquery.js,importbuddy/js/jquery.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/jquery.leanModal.min.js,importbuddy/js/jquery.leanModal.min.js
Ly8gbGVhbk1vZGFsIHYxLjEuMSBieSBSYXkgU3RvbmUgLSBodHRwOi8vZmluZWx5c2xpY2VkLmNvbS5hdQovLyBNb2RpZmllZCBieSBCcmlhbiBEaUNoaWFyYSwgdXNlZCB0cmFuc2xhdGVYKC01MCUpIHRvIGNlbnRlciBtb2RhbC4KLy8gRHVhbCBsaWNlbnNlZCB1bmRlciB0aGUgTUlUIGFuZCBHUEwKCihmdW5jdGlvbigkKXskLmZuLmV4dGVuZCh7bGVhbk1vZGFsOmZ1bmN0aW9uKG9wdGlvbnMpe3ZhciBkZWZhdWx0cz17dG9wOjEwMCxvdmVybGF5OjAuNSxjbG9zZUJ1dHRvbjpudWxsfTt2YXIgb3ZlcmxheT0kKCI8ZGl2IGlkPSdsZWFuX292ZXJsYXknPjwvZGl2PiIpOyQoImJvZHkiKS5hcHBlbmQob3ZlcmxheSk7b3B0aW9ucz0kLmV4dGVuZChkZWZhdWx0cyxvcHRpb25zKTtyZXR1cm4gdGhpcy5lYWNoKGZ1bmN0aW9uKCl7dmFyIG89b3B0aW9uczskKHRoaXMpLmNsaWNrKGZ1bmN0aW9uKGUpe3ZhciBtb2RhbF9pZD0kKHRoaXMpLmF0dHIoImhyZWYiKTskKCIjbGVhbl9vdmVybGF5IikuY2xpY2soZnVuY3Rpb24oKXtjbG9zZV9tb2RhbChtb2RhbF9pZCl9KTskKG8uY2xvc2VCdXR0b24pLmNsaWNrKGZ1bmN0aW9uKCl7Y2xvc2VfbW9kYWwobW9kYWxfaWQpfSk7dmFyIG1vZGFsX2hlaWdodD0kKG1vZGFsX2lkKS5vdXRlckhlaWdodCgpOwokKCIjbGVhbl9vdmVybGF5IikuY3NzKHsiZGlzcGxheSI6ImJsb2NrIixvcGFjaXR5OjB9KTskKCIjbGVhbl9vdmVybGF5IikuZmFkZVRvKDIwMCxvLm92ZXJsYXkpOyQobW9kYWxfaWQpLmNzcyh7ImRpc3BsYXkiOiJibG9jayIsInBvc2l0aW9uIjoiZml4ZWQiLCJvcGFjaXR5IjowLCJ6LWluZGV4IjoxMTAwMCwibGVmdCI6NTArIiUiLCJ0cmFuc2Zvcm0iOiJ0cmFuc2xhdGVYKC01MCUpIiwidG9wIjpvLnRvcCsicHgifSk7JChtb2RhbF9pZCkuZmFkZVRvKDIwMCwxKTtlLnByZXZlbnREZWZhdWx0KCl9KX0pO2Z1bmN0aW9uIGNsb3NlX21vZGFsKG1vZGFsX2lkKXskKCIjbGVhbl9vdmVybGF5IikuZmFkZU91dCgyMDApOyQobW9kYWxfaWQpLmNzcyh7ImRpc3BsYXkiOiJub25lIn0pfX19KX0pKGpRdWVyeSk7Cg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/jquery.leanModal.min.js,importbuddy/js/jquery.leanModal.min.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/main.js,importbuddy/js/main.js
alF1ZXJ5LmZuLnZpc2libGUgPSBmdW5jdGlvbigpIHsKCXJldHVybiB0aGlzLmNzcygndmlzaWJpbGl0eScsICd2aXNpYmxlJyk7Cn07CgpqUXVlcnkuZm4uaW52aXNpYmxlID0gZnVuY3Rpb24oKSB7CglyZXR1cm4gdGhpcy5jc3MoJ3Zpc2liaWxpdHknLCAnaGlkZGVuJyk7Cn07CgpqUXVlcnkuZm4udmlzaWJpbGl0eVRvZ2dsZSA9IGZ1bmN0aW9uKCkgewoJcmV0dXJuIHRoaXMuY3NzKCd2aXNpYmlsaXR5JywgZnVuY3Rpb24oaSwgdmlzaWJpbGl0eSkgewoJCXJldHVybiAodmlzaWJpbGl0eSA9PSAndmlzaWJsZScpID8gJ2hpZGRlbicgOiAndmlzaWJsZSc7Cgl9KTsKfTs=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/main.js,importbuddy/js/main.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/nprogress.js,importbuddy/js/nprogress.js
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/nprogress.js,importbuddy/js/nprogress.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/restoreEvents.js,importbuddy/js/restoreEvents.js
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/restoreEvents.js,importbuddy/js/restoreEvents.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/tooltip.js,importbuddy/js/tooltip.js
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/tooltip.js,importbuddy/js/tooltip.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/ui.core.js,importbuddy/js/ui.core.js
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/ui.core.js,importbuddy/js/ui.core.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/_assets.php,importbuddy/views/_assets.php
PD9waHAKcGJfYmFja3VwYnVkZHk6OmxvYWRfc3R5bGUoICdzdHlsZS5jc3MnICk7CnBiX2JhY2t1cGJ1ZGR5Ojpsb2FkX3N0eWxlKCAnbnByb2dyZXNzLmNzcycgKTsKcGJfYmFja3VwYnVkZHk6OmxvYWRfc3R5bGUoICdhbmltYXRlLmNzcycgKTsKCnBiX2JhY2t1cGJ1ZGR5Ojpsb2FkX3NjcmlwdCggJ2pxdWVyeS5qcycgKTsKcGJfYmFja3VwYnVkZHk6OmxvYWRfc2NyaXB0KCAndWkuY29yZS5qcycgKTsKcGJfYmFja3VwYnVkZHk6OmxvYWRfc2NyaXB0KCAndG9vbHRpcC5qcycgKTsKcGJfYmFja3VwYnVkZHk6OmxvYWRfc2NyaXB0KCAnbnByb2dyZXNzLmpzJyApOwpwYl9iYWNrdXBidWRkeTo6bG9hZF9zY3JpcHQoICdpbXBvcnRidWRkeS5qcycgKTs=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/_assets.php,importbuddy/views/_assets.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/_dbreplace.php,importbuddy/views/_dbreplace.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/_dbreplace.php,importbuddy/views/_dbreplace.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/_footer.php,importbuddy/views/_footer.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9Cj8+Cgo8L2Rpdj4KPC9kaXY+CgoKPC9ib2R5Pgo8L2h0bWw+Cg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/_footer.php,importbuddy/views/_footer.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/_header.php,importbuddy/views/_header.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/_header.php,importbuddy/views/_header.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/_html_1_stash.php,importbuddy/views/_html_1_stash.php
PD9waHAKLyoqCiAqIEhUTUwgMSBTdGFzaCBWaWV3CiAqCiAqIEBwYWNrYWdlIEJhY2t1cEJ1ZGR5CiAqLwoKZ2xvYmFsICR3cF92ZXJzaW9uOwokd3BfdmVyc2lvbiA9IDE7CgovKioKICogU3Rhc2ggQVBJIEZ1bmN0aW9uCiAqCiAqIEBwYXJhbSBhcnJheSAgJHNldHRpbmdzICAgICAgICAgICBTZXR0aW5ncyBhcnJheS4KICogQHBhcmFtIHN0cmluZyAkYWN0aW9uICAgICAgICAgICAgIEFQSSBBY3Rpb24gY2FsbC4KICogQHBhcmFtIGFycmF5ICAkYWRkaXRpb25hbF9wYXJhbXMgIEFycmF5IG9mIGFkZGl0aW9uYWwgcGFyYW1ldGVycy4KICoKICogQHJldHVybiBzdHJpbmd8YXJyYXkgIEVycm9yIHN0cmluZyBvciBKU09OIHJlc3BvbnNlIGFycmF5LgogKi8KZnVuY3Rpb24gc3Rhc2hBUEkoICRzZXR0aW5ncywgJGFjdGlvbiwgJGFkZGl0aW9uYWxfcGFyYW1zID0gYXJyYXkoKSApIHsKCSRhcGlfdXJsID0gJ2h0dHBzOi8vc3Rhc2gtYXBpLTIuaXRoZW1lcy5jb20nOwoKCWdsb2JhbCAkd3BfdmVyc2lvbjsKCSR1cmxfcGFyYW1zID0gYXJyYXkoCgkJJ2FjdGlvbicgICAgPT4gJGFjdGlvbiwKCQkndXNlcicgICAgICA9PiAkc2V0dGluZ3NbJ2l0eGFwaV91c2VybmFtZSddLAoJCSd3cCcgICAgICAgID0+ICR3cF92ZXJzaW9uLAoJCSdiYicgICAgICAgID0+IDAsCgkJJ2liJyAgICAgICAgPT4gcGJfYmFja3VwYnVkZHk6OiRvcHRpb25zWydiYl92ZXJzaW9uJ10sCgkJJ3NpdGUnICAgICAgPT4gJ2ltcG9ydGJ1ZGR5JywKCQkndGltZXN0YW1wJyA9PiB0aW1lKCksCgkpOwoKCWlmICggaXNzZXQoICRzZXR0aW5nc1snaXR4YXBpX3Bhc3N3b3JkJ10gKSApIHsgLy8gVXNlZCBvbiBpbml0aXRhbCBjb25uZWN0aW9uIHRvCgkJJHBhcmFtcyA9IGFycmF5KCAnYXV0aF90b2tlbicgPT4gJHNldHRpbmdzWydpdHhhcGlfcGFzc3dvcmQnXSApOyAvLyBpdHhhcGlfcGFzc3dvcmQgaXMgYSBIQVNIIG9mIHVzZXIncyBwYXNzd29yZC4KCX0gZWxzZWlmICggaXNzZXQoICRzZXR0aW5nc1snaXR4YXBpX3Rva2VuJ10gKSApIHsgLy8gVXNlZCBvbiBpbml0aXRhbCBjb25uZWN0aW9uIHRvCgkJJHBhcmFtcyA9IGFycmF5KCAndG9rZW4nID0+ICRzZXR0aW5nc1snaXR4YXBpX3Rva2VuJ10gKTsgLy8gaXR4YXBpX3Bhc3N3b3JkIGlzIGEgSEFTSCBvZiB1c2VyJ3MgcGFzc3dvcmQuCgl9IGVsc2UgewoJCSRlcnJvciA9ICdCYWNrdXBCdWRkeSBFcnJvciAjNzkzNzQ5NDM2OiBObyB2YWxpZCB0b2tlbiAoaXR4YXBpX3Rva2VuKSBvciBoYXNoZWQgcGFzc3dvcmQgKGl0eGFwaV9wYXNzd29yZCkgc3BlY2lmaWVkLiBUaGlzIHNob3VsZCBub3QgaGFwcGVuLic7CgkJdHJpZ2dlcl9lcnJvciggJGVycm9yLCBFX1VTRVJfTk9USUNFICk7CgkJcmV0dXJuICRlcnJvcjsKCX0KCgkkcGFyYW1zID0gYXJyYXlfbWVyZ2UoICRwYXJhbXMsICRhZGRpdGlvbmFsX3BhcmFtcyApOwoJJGJvZHkgICA9IGFycmF5KCAncmVxdWVzdCcgPT4ganNvbl9lbmNvZGUoICRwYXJhbXMgKSApOwoKCSRwb3N0X3VybCA9ICRhcGlfdXJsIC4gJy8/JyAuIGh0dHBfYnVpbGRfcXVlcnkoICR1cmxfcGFyYW1zLCBudWxsLCAnJicgKTsKCgkkcmVxdWVzdCA9IG5ldyBSZXF1ZXN0Q29yZSggJHBvc3RfdXJsICk7CgkkcmVxdWVzdC0+c2V0X21ldGhvZCggJ1BPU1QnICk7CgkkcmVxdWVzdC0+c2V0X2JvZHkoICRib2R5ICk7CgkkcmVzcG9uc2UgPSAkcmVxdWVzdC0+c2VuZF9yZXF1ZXN0KCB0cnVlICk7CgoJaWYgKCAhICRyZXNwb25zZS0+aXNPSygpICkgewoJCXBiX2JhY2t1cGJ1ZGR5OjpzdGF0dXMoICdlcnJvcicsICdTdGFzaCByZXF1ZXN0IGZvciBmaWxlcyBmYWlsZWQuJyApOwoJCXJldHVybiAkcmVzcG9uc2UtPmJvZHk7Cgl9IGVsc2UgewoJCS8vIFNlZSBpZiB3ZSBnb3QgYSBqc29uIHJlc3BvbnNlLgoJCSRyZXNwb25zZV9kZWNvZGVkID0ganNvbl9kZWNvZGUoICRyZXNwb25zZS0+Ym9keSwgdHJ1ZSApOwoJCWlmICggISAkcmVzcG9uc2VfZGVjb2RlZCApIHsKCQkJcGJfYmFja3VwYnVkZHk6OnN0YXR1cyggJ2Vycm9yJywgJ1N0YXNoIGRpZCBub3QgZ2V0IHZhbGlkIGpzb24gcmVzcG9uc2UuJyApOwoJCX0KCgkJLy8gRmluYWxseSBzZWUgaWYgdGhlIEFQSSByZXR1cm5lZCBhbiBlcnJvci4KCQlpZiAoIGlzc2V0KCAkcmVzcG9uc2VfZGVjb2RlZFsnZXJyb3InXSApICkgewoJCQlpZiAoIGlzc2V0KCAkcmVzcG9uc2VfZGVjb2RlZFsnZXJyb3InXVsnbWVzc2FnZSddICkgKSB7CgkJCQkkZXJyb3IgPSAnRXJyb3IgIzM5NzUyODkzYS4gU2VydmVyIHJlcG9ydGVkIGFuIGVycm9yIHBlcmZvcm1pbmcgYWN0aW9uIGAnIC4gJGFjdGlvbiAuICdgIHdpdGggYWRkaXRpb25hbCBwYXJhbXM6IGAnIC4gcHJpbnRfciggJGFkZGl0aW9uYWxfcGFyYW1zLCB0cnVlICkgLiAnYC4gRGV0YWlsczogYCcgLiBwcmludF9yKCAkcmVzcG9uc2VfZGVjb2RlZFsnZXJyb3InXSwgdHJ1ZSApIC4gJ2AuJzsKCQkJCXBiX2JhY2t1cGJ1ZGR5OjpzdGF0dXMoICd3YXJuaW5nJywgJGVycm9yICk7CgkJCQlyZXR1cm4gJHJlc3BvbnNlX2RlY29kZWRbJ2Vycm9yJ11bJ21lc3NhZ2UnXTsKCQkJfSBlbHNlIHsKCQkJCSRlcnJvciA9ICdFcnJvciAjMzgyMzk3My4gUmVjZWl2ZWQgU3Rhc2ggQVBJIGVycm9yIGJ1dCBubyBtZXNzYWdlIGZvdW5kLiBEZXRhaWxzOiBgJyAuIHByaW50X3IoICRyZXNwb25zZV9kZWNvZGVkLCB0cnVlICkgLiAnYC4nOwoJCQkJcGJfYmFja3VwYnVkZHk6OnN0YXR1cyggJ3dhcm5pbmcnLCAkZXJyb3IgKTsKCQkJCXJldHVybiAkZXJyb3I7CgkJCX0KCQl9IGVsc2UgeyAvLyBOTyBFUlJPUlMuCgkJCXJldHVybiAkcmVzcG9uc2VfZGVjb2RlZDsKCQl9Cgl9Cn0KPz4KCjxzdHlsZT4KLndpZGVmYXQgdGQgewoJcGFkZGluZzogMjBweCA3cHg7Cglmb250LXNpemU6IDE0cHg7Cn0KLndpZGVmYXQgdGQgYTpob3ZlciB7Cgl0ZXh0LWRlY29yYXRpb246IG5vbmU7Cn0KLndpZGVmYXQgdGQgZm9ybSB7CgltYXJnaW4tdG9wOiAtMTJweDsKCWZvbnQtc2l6ZTogMTJweDsKfQouc3Rhc2hfYmFja3VwX2ZpbGUgewoJZm9udC1zaXplOiAxLjJlbTsKfQo8L3N0eWxlPgo8P3BocAokSVRYQVBJX0tFWSA9ICdpeGhvN2RrMHAyNDRuMG9iJzsgLy8gTW92ZSB0byBhIGNvbnN0YW50PwokSVRYQVBJX1VSTCA9ICdodHRwOi8vYXBpLml0aGVtZXMuY29tJzsgLy8gTW92ZSB0byBhIGNvbnN0YW50PwoKJGNyZWRlbnRpYWxzX2Zvcm0gPSBuZXcgcGJfYmFja3VwYnVkZHlfc2V0dGluZ3MoICdwcmVfc2V0dGluZ3MnLCBmYWxzZSwgJ3VwbG9hZD1zdGFzaCNwbHVnaW5idWRkeS10YWJzLXN0YXNoJyApOyAvLyBuYW1lLCBzYXZlcG9pbnR8ZmFsc2UsIGFkZGl0aW9uYWwgcXVlcnlzdHJpbmcuCgokY3JlZGVudGlhbHNfZm9ybS0+YWRkX3NldHRpbmcoCglhcnJheSgKCQkndHlwZScgID0+ICd0ZXh0JywKCQknbmFtZScgID0+ICdpdHhhcGlfdXNlcm5hbWUnLAoJCSd0aXRsZScgPT4gX18oICdpVGhlbWVzIHVzZXJuYW1lJywgJ2l0LWwxMG4tYmFja3VwYnVkZHknICksCgkJJ3J1bGVzJyA9PiAncmVxdWlyZWR8c3RyaW5nWzEtNDVdJywKCSkKKTsKJGNyZWRlbnRpYWxzX2Zvcm0tPmFkZF9zZXR0aW5nKAoJYXJyYXkoCgkJJ3R5cGUnICA9PiAncGFzc3dvcmQnLAoJCSduYW1lJyAgPT4gJ2l0eGFwaV9wYXNzd29yZF9yYXcnLAoJCSd0aXRsZScgPT4gX18oICdpVGhlbWVzIHBhc3N3b3JkJywgJ2l0LWwxMG4tYmFja3VwYnVkZHknICksCgkJJ3J1bGVzJyA9PiAncmVxdWlyZWR8c3RyaW5nWzEtNDVdJywKCSkKKTsKCiRzZXR0aW5nc19yZXN1bHQgPSAkY3JlZGVudGlhbHNfZm9ybS0+cHJvY2VzcygpOwokbG9naW5fd2VsY29tZSAgID0gJzxjZW50ZXI+JyAuIF9fKCAnTG9nIGluIHRvIFN0YXNoIHdpdGggeW91ciBpVGhlbWVzLmNvbSBtZW1iZXIgYWNjb3VudC4nLCAnaXQtbDEwbi1iYWNrdXBidWRkeScgKSAuICc8YnI+PGJyPic7CgppZiAoIGNvdW50KCAkc2V0dGluZ3NfcmVzdWx0ICkgPT09IDAgKSB7IC8vIE5vIGZvcm0gc3VibWl0dGVkLgoKCWVjaG8gJGxvZ2luX3dlbGNvbWU7CgkkY3JlZGVudGlhbHNfZm9ybS0+ZGlzcGxheV9zZXR0aW5ncyggJ0Nvbm5lY3QgdG8gU3Rhc2gnICk7Cgp9IGVsc2UgeyAvLyBGb3JtIHN1Ym1pdHRlZC4KCWlmICggY291bnQoICRzZXR0aW5nc19yZXN1bHRbJ2Vycm9ycyddICkgPiAwICkgeyAvLyBGb3JtIGVycm9ycy4KCQllY2hvICRsb2dpbl93ZWxjb21lOwoKCQlwYl9iYWNrdXBidWRkeTo6YWxlcnQoIGltcGxvZGUoICc8YnI+JywgJHNldHRpbmdzX3Jlc3VsdFsnZXJyb3JzJ10gKSApOwoJCSRjcmVkZW50aWFsc19mb3JtLT5kaXNwbGF5X3NldHRpbmdzKCAnQ29ubmVjdCB0byBTdGFzaCcgKTsKCgl9IGVsc2UgeyAvLyBObyBmb3JtIGVycm9yczsgcHJvY2VzcyEKCgkJcmVxdWlyZV9vbmNlIGRpcm5hbWUoIGRpcm5hbWUoIF9fRklMRV9fICkgKSAuICcvbGliL3JlcXVlc3Rjb3JlL3JlcXVlc3Rjb3JlLmNsYXNzLnBocCc7CgkJcmVxdWlyZV9vbmNlIGRpcm5hbWUoIGRpcm5hbWUoIF9fRklMRV9fICkgKSAuICcvbGliL3N0YXNoMi9jbGFzcy5pdHhfaGVscGVyMi5waHAnOwoKCQlnbG9iYWwgJHdwX3ZlcnNpb247CgkJJGl0eGFwaV91c2VybmFtZSA9IHN0cnRvbG93ZXIoICRzZXR0aW5nc19yZXN1bHRbJ2RhdGEnXVsnaXR4YXBpX3VzZXJuYW1lJ10gKTsKCQkkcGFzc3dvcmRfaGFzaCAgID0gaVRoZW1lc19DcmVkZW50aWFsczo6Z2V0X3Bhc3N3b3JkX2hhc2goICRpdHhhcGlfdXNlcm5hbWUsICRzZXR0aW5nc19yZXN1bHRbJ2RhdGEnXVsnaXR4YXBpX3Bhc3N3b3JkX3JhdyddICk7CgkJJGFjY2Vzc190b2tlbiAgICA9IElUWEFQSV9IZWxwZXIyOjpnZXRfYWNjZXNzX3Rva2VuKCAkaXR4YXBpX3VzZXJuYW1lLCAkcGFzc3dvcmRfaGFzaCwgJ2ltcG9ydGJ1ZGR5JywgJHdwX3ZlcnNpb24gKTsKCgkJJHNldHRpbmdzID0gYXJyYXkoCgkJCSdpdHhhcGlfdXNlcm5hbWUnID0+ICRpdHhhcGlfdXNlcm5hbWUsCgkJCSdpdHhhcGlfcGFzc3dvcmQnID0+ICRhY2Nlc3NfdG9rZW4sCgkJKTsKCQkkcmVzcG9uc2UgPSBzdGFzaEFQSSggJHNldHRpbmdzLCAnY29ubmVjdCcgKTsKCgkJJGxvZ2dlZF9pbiA9IGZhbHNlOwoJCWlmICggISBpc19hcnJheSggJHJlc3BvbnNlICkgKSB7IC8vIEVycm9yIG1lc3NhZ2UuCgkJCXBiX2JhY2t1cGJ1ZGR5OjphbGVydCggJ0Vycm9yICMzOTgzNzk0IGZyb20gc2VydmVyOiBgJyAuIHByaW50X3IoICRyZXNwb25zZSwgdHJ1ZSApIC4gJ2AuJyApOwoJCQkkY3JlZGVudGlhbHNfZm9ybS0+ZGlzcGxheV9zZXR0aW5ncyggJ1N1Ym1pdCcgKTsKCQl9IGVsc2UgewoJCQlpZiAoIGlzc2V0KCAkcmVzcG9uc2VbJ2Vycm9yJ10gKSApIHsKCQkJCXBiX2JhY2t1cGJ1ZGR5OjphbGVydCggJ0Vycm9yOiAnIC4gJHJlc3BvbnNlWydlcnJvciddWydtZXNzYWdlJ10gKTsKCQkJCSRjcmVkZW50aWFsc19mb3JtLT5kaXNwbGF5X3NldHRpbmdzKCAnU3VibWl0JyApOwoJCQl9IGVsc2UgewoJCQkJaWYgKCBpc3NldCggJHJlc3BvbnNlWyd0b2tlbiddICkgKSB7CgkJCQkJJHNldHRpbmdzWydpdHhhcGlfdG9rZW4nXSA9ICRyZXNwb25zZVsndG9rZW4nXTsKCQkJCQkkaXR4YXBpX3Rva2VuICAgICAgICAgICAgID0gJHNldHRpbmdzWydpdHhhcGlfdG9rZW4nXTsKCQkJCQl1bnNldCggJHNldHRpbmdzWydpdHhhcGlfcGFzc3dvcmQnXSApOyAvLyBObyBsb25nZXJuIGVlZGVkIHNpbmNlIHdlIGhhdmUgdG9rZW4gbm93LgoJCQkJCSRsb2dnZWRfaW4gPSB0cnVlOwoJCQkJfSBlbHNlIHsKCQkJCQlwYl9iYWNrdXBidWRkeTo6YWxlcnQoICdFcnJvciAjMzQ5NzQ3MzQzMjM6IFVuZXhwZWN0ZWQgc2VydmVyIHJlc3BvbnNlLiBUb2tlbiBtaXNzaW5nLiBDaGVjayB5b3VyIGxvZ2luIGFuZCB0cnkgYWdhaW4uIERldGFpbGVkIHJlc3BvbnNlOiBgJyAuIHByaW50X3IoICRyZXNwb25zZSwgdHJ1ZSApIC4gJ2AuJyApOwoJCQkJCSRjcmVkZW50aWFsc19mb3JtLT5kaXNwbGF5X3NldHRpbmdzKCAnU3VibWl0JyApOwoJCQkJfQoJCQl9CgkJfQoKCQlpZiAoIHRydWUgPT09ICRsb2dnZWRfaW4gKSB7CgkJCS8vIEdldCBmaWxlcy4KCQkJJHN0YXNoX2ZpbGVzID0gc3Rhc2hBUEkoICRzZXR0aW5ncywgJ2ZpbGVzJyApOwoKCQkJLy8gRmluYWxseSBzZWUgaWYgdGhlIEFQSSByZXR1cm5lZCBhbiBlcnJvci4KCQkJaWYgKCAhIGlzX2FycmF5KCAkc3Rhc2hfZmlsZXMgKSApIHsKCQkJCXBiX2JhY2t1cGJ1ZGR5OjphbGVydCggJ1N0YXNoIEVycm9yOiAnIC4gJHN0YXNoX2ZpbGVzICk7CgkJCQkkY3JlZGVudGlhbHNfZm9ybS0+ZGlzcGxheV9zZXR0aW5ncyggJ1N1Ym1pdCcgKTsKCQkJfSBlbHNlIHsgLy8gTk8gRVJST1JTLgoKCgkJCQkvLyBTb3J0IGluIG9yZGVyICYgZXhjbHVkZSB1bndhbnRlZCBiYWNrdXAgdHlwZXMuCgkJCQkkYmFja3VwX2xpc3RfdGVtcCA9IGFycmF5KCk7CgkJCQlmb3JlYWNoICggKGFycmF5KSAkc3Rhc2hfZmlsZXMgYXMgJGkgPT4gJHN0YXNoX2ZpbGUgKSB7CgkJCQkJJGZpbGUgICAgID0gJHN0YXNoX2ZpbGVbJ2ZpbGVuYW1lJ107CgkJCQkJJHVybCAgICAgID0gJHN0YXNoX2ZpbGVbJ3VybCddOwoJCQkJCSRzaXplICAgICA9ICRzdGFzaF9maWxlWydzaXplJ107CgkJCQkJJG1vZGlmaWVkID0gJHN0YXNoX2ZpbGVbJ3VwbG9hZGVkX3RpbWVzdGFtcCddOwoKCQkJCQkvLyBBdm9pZCBjb2xsaW9uIGZvciBzb3J0aW5nLgoJCQkJCXdoaWxlICggaXNzZXQoICRiYWNrdXBfbGlzdF90ZW1wWyAkbW9kaWZpZWQgXSApICkgewoJCQkJCQkkbW9kaWZpZWQgKz0gMC4xOwoJCQkJCX0KCgkJCQkJaWYgKCAnZGInID09ICRzdGFzaF9maWxlWydiYWNrdXBfdHlwZSddICkgewoJCQkJCQkkYmFja3VwX3R5cGUgPSAnRGF0YWJhc2UnOwoJCQkJCX0gZWxzZWlmICggJ2Z1bGwnID09ICRzdGFzaF9maWxlWydiYWNrdXBfdHlwZSddICkgewoJCQkJCQkkYmFja3VwX3R5cGUgPSAnRnVsbCc7CgkJCQkJfSBlbHNlaWYgKCAndGhlbWVzJyA9PSAkc3Rhc2hfZmlsZVsnYmFja3VwX3R5cGUnXSApIHsgLy8gT21pdCBmcm9tIGxpc3QuCgkJCQkJCXVuc2V0KCAkc3Rhc2hfZmlsZXNbICRpIF0gKTsKCQkJCQkJY29udGludWU7CgkJCQkJfSBlbHNlaWYgKCAncGx1Z2lucycgPT0gJHN0YXNoX2ZpbGVbJ2JhY2t1cF90eXBlJ10gKSB7IC8vIE9taXQgZnJvbSBsaXN0LgoJCQkJCQl1bnNldCggJHN0YXNoX2ZpbGVzWyAkaSBdICk7CgkJCQkJCWNvbnRpbnVlOwoJCQkJCX0gZWxzZWlmICggJ21lZGlhJyA9PSAkc3Rhc2hfZmlsZVsnYmFja3VwX3R5cGUnXSApIHsgLy8gT21pdCBmcm9tIGxpc3QuCgkJCQkJCXVuc2V0KCAkc3Rhc2hfZmlsZXNbICRpIF0gKTsKCQkJCQkJY29udGludWU7CgkJCQkJfSBlbHNlaWYgKCAnZmlsZXMnID09ICRzdGFzaF9maWxlWydiYWNrdXBfdHlwZSddICkgewoJCQkJCQkkYmFja3VwX3R5cGUgPSAnRmlsZXMnOwoJCQkJCX0gZWxzZSB7CgkJCQkJCSRiYWNrdXBfdHlwZSA9ICdVbmtub3duJzsKCQkJCQkJY29udGludWU7CgkJCQkJfQoJCQkJCSRzdGFzaF9maWxlWydiYWNrdXBfdHlwZV9wcmV0dHknXSA9ICRiYWNrdXBfdHlwZTsKCgkJCQkJJGJhY2t1cF9saXN0X3RlbXBbICRtb2RpZmllZCBdID0gJHN0YXNoX2ZpbGU7CgkJCQl9CgkJCQlrcnNvcnQoICRiYWNrdXBfbGlzdF90ZW1wICk7CgkJCQkkc3Rhc2hfZmlsZXMgPSAkYmFja3VwX2xpc3RfdGVtcDsKCQkJCXVuc2V0KCAkYmFja3VwX2xpc3RfdGVtcCApOwoKCgkJCQkvLyBTcGxpdCB1cCBpbnRvIHNpdGVzLgoJCQkJJGJhY2t1cF9saXN0cyA9IGFycmF5KCk7CgkJCQlmb3JlYWNoICggJHN0YXNoX2ZpbGVzIGFzICRzdGFzaF9maWxlICkgewoJCQkJCSRiYWNrdXBfbGlzdHNbICRzdGFzaF9maWxlWydzaXRlJ10gXVtdID0gJHN0YXNoX2ZpbGU7CgkJCQl9CgkJCQl1bnNldCggJHN0YXNoX2ZpbGVzICk7CgoKCQkJCS8vIFJlbmRlciB0YWJsZSBsaXN0aW5nIGZpbGVzLgoJCQkJaWYgKCBjb3VudCggJGJhY2t1cF9saXN0cyApID09IDAgKSB7CgkJCQkJZWNobyAnPGI+JzsKCQkJCQllc2NfaHRtbF9lKCAnWW91IGhhdmUgbm90IHNlbnQgYW55IGJhY2t1cHMgdG8gU3Rhc2ggeWV0IChvciBmaWxlcyBhcmUgc3RpbGwgdHJhbnNmZXJyaW5nKS4nLCAnaXQtbDEwbi1iYWNrdXBidWRkeScgKTsKCQkJCQllY2hvICc8L2I+JzsKCQkJCX0gZWxzZSB7CgoJCQkJCS8vIExvb3AgdGhyb3VnaCBlYWNoIHNpdGUuCgkJCQkJZm9yZWFjaCAoICRiYWNrdXBfbGlzdHMgYXMgJHN0YXNoX2ZpbGVzICkgeyAvLyBFYWNoIHNpdGUuCgoJCQkJCQkvLyBMb29wIHRocm91Z2ggZWFjaCBmaWxlIHdpdGhpbiB0aGlzIHNpdGUuCgkJCQkJCSRkaXNwbGF5X2xpc3QgPSBhcnJheSgpOwoJCQkJCQlmb3JlYWNoICggJHN0YXNoX2ZpbGVzIGFzICRzdGFzaF9maWxlICkgeyAvLyBFYWNoIGJhY2t1cCBpbiBzaXRlLgoJCQkJCQkJJHNpdGUgPSAkc3Rhc2hfZmlsZVsnc2l0ZSddOwoKCQkJCQkJCSRkaXNwbGF5X2xpc3RbXSA9IGFycmF5KAoJCQkJCQkJCSRzdGFzaF9maWxlWydiYWNrdXBfdHlwZV9wcmV0dHknXSwKCQkJCQkJCQknPHNwYW4gY2xhc3M9InN0YXNoX2JhY2t1cF9maWxlIj4nIC4gcGJfYmFja3VwYnVkZHk6OiRmb3JtYXQtPmRhdGUoIHBiX2JhY2t1cGJ1ZGR5OjokZm9ybWF0LT5sb2NhbGl6ZV90aW1lKCAkc3Rhc2hfZmlsZVsndXBsb2FkZWRfdGltZXN0YW1wJ10gKSwgJ2wsIEYgaiwgWSAtIGc6aSBBJyApIC4gJzwvc3Bhbj4gPHNwYW4gY2xhc3M9ImRlc2NyaXB0aW9uIj4oJyAuIHBiX2JhY2t1cGJ1ZGR5OjokZm9ybWF0LT50aW1lX2FnbyggJHN0YXNoX2ZpbGVbJ3VwbG9hZGVkX3RpbWVzdGFtcCddICkgLiAnIGFnbyk8L3NwYW4+PC9hPjxicj48YSBocmVmPSInIC4gJHN0YXNoX2ZpbGVbJ3VybCddIC4gJyI+JyAuICRzdGFzaF9maWxlWydiYXNlbmFtZSddIC4gJzwvYT4nLAoJCQkJCQkJCXBiX2JhY2t1cGJ1ZGR5OjokZm9ybWF0LT5maWxlX3NpemUoICRzdGFzaF9maWxlWydzaXplJ10gKSwKCQkJCQkJCQknPGZvcm0gYWN0aW9uPSI/I3BsdWdpbmJ1ZGR5LXRhYnMtc2VydmVyIiBtZXRob2Q9IlBPU1QiPgoJCQkJCQkJCQk8aW5wdXQgdHlwZT0iaGlkZGVuIiBuYW1lPSJwYXNzX2hhc2giIHZhbHVlPSInIC4gUEJfUEFTU1dPUkQgLiAnIj4KCQkJCQkJCQkJPGlucHV0IHR5cGU9ImhpZGRlbiIgbmFtZT0idXBsb2FkIiB2YWx1ZT0ic3Rhc2giPgoJCQkJCQkJCQk8aW5wdXQgdHlwZT0iaGlkZGVuIiBuYW1lPSJvcHRpb25zIiB2YWx1ZT0iJyAuIGh0bWxzcGVjaWFsY2hhcnMoIHNlcmlhbGl6ZSggcGJfYmFja3VwYnVkZHk6OiRvcHRpb25zICkgKSAuICciPgoJCQkJCQkJCQk8aW5wdXQgdHlwZT0iaGlkZGVuIiBuYW1lPSJsaW5rIiB2YWx1ZT0iJyAuICRzdGFzaF9maWxlWyd1cmwnXSAuICciPgoJCQkJCQkJCQk8aW5wdXQgdHlwZT0ic3VibWl0IiBuYW1lPSJzdWJtaXQiIHZhbHVlPSJSZXN0b3JlIiBjbGFzcz0iYnV0dG9uLXByaW1hcnkiPgoJCQkJCQkJCTwvZm9ybT4nLAoKCQkJCQkJCSk7CgkJCQkJCX0KCgkJCQkJCWVjaG8gJzxoMz5TaXRlOiAnIC4gZXNjX2h0bWwoICRzaXRlICkgLiAnPC9oMz4nOwoJCQkJCQlwYl9iYWNrdXBidWRkeTo6JHVpLT5saXN0X3RhYmxlKAoJCQkJCQkJJGRpc3BsYXlfbGlzdCwKCQkJCQkJCWFycmF5KAoJCQkJCQkJCSdjb2x1bW5zJyA9PiBhcnJheSggJ1R5cGUnLCAnVXBsb2FkZWQ8aW1nIHNyYz0iJyAuIHBiX2JhY2t1cGJ1ZGR5OjpwbHVnaW5fdXJsKCkgLiAnL2ltYWdlcy9zb3J0X2Rvd24ucG5nIiBzdHlsZT0idmVydGljYWwtYWxpZ246IDBweDsiIHRpdGxlPSJTb3J0ZWQgbW9zdCByZWNlbnQgZmlyc3QiPjxzcGFuIGNsYXNzPSJkZXNjcmlwdGlvbiI+KENsaWNrIHRvIGRvd25sb2FkKTwvc3Bhbj4nLCAnRmlsZSBTaXplJywgJ0FjdGlvbicgKSwKCQkJCQkJCQknY3NzJyAgICAgPT4gJ3dpZHRoOiAxMDAlOycsCgkJCQkJCQkpCgkJCQkJCSk7CgkJCQkJCWVjaG8gJzxicj48YnI+JzsKCgkJCQkJfQoJCQkJfQoJCQl9IC8vIGVuZCBubyBlcnJvcnMgZ2V0dGluZyBmaWxlIGluZm8gZnJvbSBBUEkuCgkJfSBlbHNlIHsgLy8gZW5kIGxvZ2dlZCBpbi4KCQkJcGJfYmFja3VwYnVkZHk6OmFsZXJ0KCAnU3Rhc2ggTG9naW4gRXJyb3IuJyApOwoJCQkkY3JlZGVudGlhbHNfZm9ybS0+ZGlzcGxheV9zZXR0aW5ncyggJ1N1Ym1pdCcgKTsKCQl9Cgl9Cn0gLy8gZW5kIGZvcm0gc3VibWl0dGVkLgoKPz4KCjxicj48aHI+CjxjZW50ZXI+Cgk8YSBocmVmPSJodHRwczovL3N5bmMuaXRoZW1lcy5jb20vc3Rhc2giIHRhcmdldD0iX2JsYW5rIiBjbGFzcz0iYnV0dG9uIGJ1dHRvbi1zZWNvbmRhcnkiPk1hbmFnZSB5b3VyIFN0YXNoIGZpbGVzIHZpYSBpVGhlbWVzIFN5bmM8L2E+CjwvY2VudGVyPgo8YnI+Cg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/_html_1_stash.php,importbuddy/views/_html_1_stash.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/_iframe_footer.php,importbuddy/views/_iframe_footer.php
CTxzY3JpcHQ+Ly9iYl9hY3Rpb24oICdpZnJhbWVMb2FkZWQnICk7PC9zY3JpcHQ+CjwvaHRtbD4=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/_iframe_footer.php,importbuddy/views/_iframe_footer.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/_iframe_header.php,importbuddy/views/_iframe_header.php
PGh0bWw+Cjw/cGhwCnJlcXVpcmUoICdfYXNzZXRzLnBocCcgKTsKCgoKaWYgKCAndHJ1ZScgIT0gcGJfYmFja3VwYnVkZHk6Ol9HRVQoICdkZXBsb3knICkgKSB7IC8vIE5PUk1BTCwgTk9UIERFUExPWU1FTlQuCj8+Cgk8c2NyaXB0PgoJCXZhciB3aW4gPSB3aW5kb3cuZGlhbG9nQXJndW1lbnRzIHx8IG9wZW5lciB8fCBwYXJlbnQgfHwgdG9wOwoJCXdpbi53aW5kb3cuc2Nyb2xsVG8oMCwwKTsKCQkKCQlmdW5jdGlvbiBwYl9zdGF0dXNfYXBwZW5kKCBzdGF0dXNfc3RyaW5nICkgewoJCQkvL3ZhciB3aW4gPSB3aW5kb3cuZGlhbG9nQXJndW1lbnRzIHx8IG9wZW5lciB8fCBwYXJlbnQgfHwgdG9wOwoJCQl3aW4ucGJfc3RhdHVzX2FwcGVuZCggc3RhdHVzX3N0cmluZyApOwoJCX0KCQlmdW5jdGlvbiBwYl9zdGF0dXNfdW5kb3VybCggdW5kb191cmwgKSB7CgkJCS8vdmFyIHdpbiA9IHdpbmRvdy5kaWFsb2dBcmd1bWVudHMgfHwgb3BlbmVyIHx8IHBhcmVudCB8fCB0b3A7CgkJCXdpbi5wYl9zdGF0dXNfdW5kb3VybCggdW5kb191cmwgKTsKCQl9CgkJCgkJCgkJCgkJZnVuY3Rpb24gcGFnZVRpdGxlKCB0aXRsZSApIHsKCQkJCgkJCXdpbi5qUXVlcnkoICcjcGFnZVRpdGxlJyApLmh0bWwoIHRpdGxlICk7CgkJfQoJCQoJCWZ1bmN0aW9uIGJiX2FjdGlvbiggYWN0aW9uLCBub3RlICkgewoJCQl3aW4uYmJfYWN0aW9uKCBhY3Rpb24sIG5vdGUgKTsKCQl9CgkJCgkJZnVuY3Rpb24gYmJfcmVzdG9yZURhdGEoIGRhdGEgKSB7CgkJCXdpbi5iYl9yZXN0b3JlRGF0YSggZGF0YSApOwoJCX0KCQkKCQlmdW5jdGlvbiBiYl9zaG93U3RlcCggc3RlcCwgZGF0YSApIHsKCQkJd2luLmJiX3Nob3dTdGVwKCBzdGVwLCBkYXRhICk7CgkJfQoJCQoJPC9zY3JpcHQ+Cjw/cGhwIH0gZWxzZSB7IC8vIERFUExPWU1FTlQgPz4KCTxzY3JpcHQ+CgkJZnVuY3Rpb24gcGJfc3RhdHVzX2FwcGVuZCgpIHsKCQl9CgkJCgkJZnVuY3Rpb24gcGJfc3RhdHVzX3VuZG91cmwoIHVuZG9fdXJsICkgewoJCX0KCQkKCQlmdW5jdGlvbiBwYWdlVGl0bGUoIHRpdGxlICkgewoJCX0KCQkKCQlmdW5jdGlvbiBiYl9hY3Rpb24oIGFjdGlvbiwgbm90ZSApIHsKCQl9CgkJCgkJZnVuY3Rpb24gYmJfcmVzdG9yZURhdGEoIGRhdGEgKSB7CgkJfQoJCQoJCWZ1bmN0aW9uIGJiX3Nob3dTdGVwKCBzdGVwLCBkYXRhICkgewoJCX0KCTwvc2NyaXB0Pgo8P3BocCB9ID8+
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/_iframe_header.php,importbuddy/views/_iframe_header.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/cleanupSettings.htm,importbuddy/views/cleanupSettings.htm
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/cleanupSettings.htm,importbuddy/views/cleanupSettings.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/cpanelTutorial.htm,importbuddy/views/cpanelTutorial.htm
PG9iamVjdCBjbGFzc2lkPSJjbHNpZDpkMjdjZGI2ZS1hZTZkLTExY2YtOTZiOC00NDQ1NTM1NDAwMDAiIGNvZGViYXNlPSJodHRwOi8vZnBkb3dubG9hZC5tYWNyb21lZGlhLmNvbS9wdWIvc2hvY2t3YXZlL2NhYnMvZmxhc2gvc3dmbGFzaC5jYWIjdmVyc2lvbj03LDAsMCwwIiBpZD0iQ2FwdGl2YXRlMSI+Cgk8cGFyYW0gbmFtZT0ibW92aWUiIHZhbHVlPSJodHRwOi8vd3d3LmNwYW5lbC5uZXQvbWVkaWEvdHV0b3JpYWxzL215c3Fsd2l6YXJkLnN3ZiI+Cgk8cGFyYW0gbmFtZT0icXVhbGl0eSIgdmFsdWU9ImhpZ2giPjxwYXJhbSBuYW1lPSJsb29wIiB2YWx1ZT0iMCI+Cgk8ZW1iZWQgc3JjPSJodHRwOi8vd3d3LmNwYW5lbC5uZXQvbWVkaWEvdHV0b3JpYWxzL215c3Fsd2l6YXJkLnN3ZiIgd2lkdGg9IjEwMCUiIGhlaWdodD0iNTAwIiBsb29wPSIwIiBxdWFsaXR5PSJsb3ciIHBsdWdpbnNwYWdlPSJodHRwOi8vd3d3Lm1hY3JvbWVkaWEuY29tL2dvL2dldGZsYXNocGxheWVyIiB0eXBlPSJhcHBsaWNhdGlvbi94LXNob2Nrd2F2ZS1mbGFzaCIgbWVudT0iZmFsc2UiPgo8L29iamVjdD4=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/cpanelTutorial.htm,importbuddy/views/cpanelTutorial.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/databaseSettings.htm,importbuddy/views/databaseSettings.htm
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/databaseSettings.htm,importbuddy/views/databaseSettings.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/dbreplace.php,importbuddy/views/dbreplace.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/dbreplace.php,importbuddy/views/dbreplace.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/finalCleanup.htm,importbuddy/views/finalCleanup.htm
VGhpcyBzdGVwIGhhbmRsZXMgZGVsZXRpbmcgZmlsZXMuIEluIHJhcmUgaW5zdGFuY2VzIG9uIHNvbWUgc2VydmVycyB5b3UgbWF5IHJlY2VpdmUgZXJyb3JzIGxvYWRpbmcgZmlsZXMgb3IgYW4gdW5zdHlsZWQgcGFnZSBoZXJlIGR1ZSB0byBmaWxlcyBnZXR0aW5nIGRlbGV0aW5nIHByZW1hdHVyZWx5IGJlZm9yZSB0aGUgcGFnZSBjb21wbGV0ZXMgbG9hZGluZy4gVGhpcyBtYXkgc2FmZWx5IGJlIGlnbm9yZWQuIEl0IGlzIGNvbW1vbiB0byBub3QgYmUgYWJsZSB0byBkZWxldGUgc29tZSBmaWxlcyBkdWUgdG8gcGVybWlzc2lvbiBlcnJvcnMuIFlvdSBtYXkgbWFudWFsbHkgZGVsZXRlIHRoZW0uIDxiPmltcG9ydGJ1ZGR5LnBocDwvYj4gc2hvdWxkIGFsd2F5cyBiZSBkZWxldGVkIGFmdGVyIHJlc3RvcmUgZm9yIGJlc3Qgc2VjdXJpdHkuCgo8aDMgc3R5bGU9InRleHQtYWxpZ246IGNlbnRlcjsiPllvdXIgc2l0ZSBpcyByZWFkeSB0byBnbyBhdAo8YSBocmVmPSI8JT1ob21ldXJsJT4iIHRhcmdldD0iX2JsYW5rIj48Yj48JT1ob21ldXJsJT48L2I+PC9hPjxicj48YnI+ClRoYW5rIHlvdSBmb3IgY2hvb3NpbmcgQmFja3VwQnVkZHkhPC9oMz4KCgo8L2Rpdj48L2Rpdj48YnI+PGJyPjxicj4=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/finalCleanup.htm,importbuddy/views/finalCleanup.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/finished.htm,importbuddy/views/finished.htm
PGgxIGNsYXNzPSJhbmltYXRlZCBmYWRlSW5Eb3duIj5SZXN0b3JlIEZpbmlzaGVkLjwvaDE+Cgo8aDM+WW91ciBzaXRlIHNob3VsZCBiZSByZWFkeSB0byBnbyBhdDo8YnI+PGJyPjxhIGhyZWY9IjwlPWhvbWV1cmwlPiIgdGFyZ2V0PSJfYmxhbmsiPjwlPWhvbWV1cmwlPjwvYT48L2gzPjxicj4=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/finished.htm,importbuddy/views/finished.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/home.php,importbuddy/views/home.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/home.php,importbuddy/views/home.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/importingDatabase.htm,importbuddy/views/importingDatabase.htm
PGNlbnRlcj4KCTxoMz5SZXN0b3JpbmcgRGF0YWJhc2UgLi4uPC9oMz4KCTxoNCBpZD0iaW1wb3J0aW5nRGF0YWJhc2UtcHJvZ3Jlc3NNZXNzYWdlIj48L2g0Pgo8L2NlbnRlcj4=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/importingDatabase.htm,importbuddy/views/importingDatabase.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/index.php,importbuddy/views/index.php
PD9waHAgLy8gU2lsZW5jZSBpcyBnb2xkZW4u
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/index.php,importbuddy/views/index.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/login.php,importbuddy/views/login.php
PHNjcmlwdD5qUXVlcnkoICcjcGFnZVRpdGxlJyApLmh0bWwoICdBdXRoZW50aWNhdGlvbiBSZXF1aXJlZCcgKTs8L3NjcmlwdD4KPD9waHAKCgppZiAoIHBiX2JhY2t1cGJ1ZGR5OjpfUE9TVCggJ3Bhc3N3b3JkJyApICE9ICcnICkgewoJZ2xvYmFsICRwYl9sb2dpbl9hdHRlbXB0czsKCXBiX2JhY2t1cGJ1ZGR5OjphbGVydCggJ0ludmFsaWQgcGFzc3dvcmQuIFBsZWFzZSBlbnRlciB0aGUgcGFzc3dvcmQgeW91IHByb3ZpZGVkIHdpdGhpbiBCYWNrdXBCdWRkeSBTZXR0aW5ncy4gQXR0ZW1wdCAjJyAuICRwYl9sb2dpbl9hdHRlbXB0cyAuICcuJyApOwoJZWNobyAnPGJyPic7Cn0KPz4KCjxwPkVudGVyIHlvdXIgSW1wb3J0QnVkZHkgcGFzc3dvcmQgYmVsb3cgdG8gYmVnaW4uPC9wPgoKPGZvcm0gbWV0aG9kPSJwb3N0Ij4KCTxpbnB1dCB0eXBlPSJoaWRkZW4iIG5hbWU9ImFjdGlvbiIgdmFsdWU9ImxvZ2luIj4KCTxpbnB1dCB0eXBlPSJwYXNzd29yZCIgbmFtZT0icGFzc3dvcmQiIHN0eWxlPSJ3aWR0aDogMjUwcHg7Ij4KCTxpbnB1dCB0eXBlPSJzdWJtaXQiIG5hbWU9InN1Ym1pdCIgdmFsdWU9IkF1dGhlbnRpY2F0ZSIgY2xhc3M9Iml0LWJ1dHRvbiI+CjwvZm9ybT4K
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/login.php,importbuddy/views/login.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/migratingDatabase.htm,importbuddy/views/migratingDatabase.htm
PGNlbnRlcj4KCTxoMz5NaWdyYXRpbmcgRGF0YWJhc2UgLi4uPC9oMz4KCTxoNCBpZD0ibWlncmF0aW5nRGF0YWJhc2UtcHJvZ3Jlc3NNZXNzYWdlIj48L2g0Pgo8L2NlbnRlcj4=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/migratingDatabase.htm,importbuddy/views/migratingDatabase.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/unzippingFiles.htm,importbuddy/views/unzippingFiles.htm
PGNlbnRlcj4KCTxoMz5QbGVhc2Ugd2FpdCB3aGlsZSB5b3VyIGZpbGVzIGFyZSByZXN0b3JlZCAuLi48L2gzPgoJPGg0IGlkPSJ1bnppcHBpbmdGaWxlcy1wcm9ncmVzc01lc3NhZ2UiPlJlc3RvcmluZyBGaWxlczwvaDQ+CjwvY2VudGVyPg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/unzippingFiles.htm,importbuddy/views/unzippingFiles.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/urlReplaceSettings.htm,importbuddy/views/urlReplaceSettings.htm
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/urlReplaceSettings.htm,importbuddy/views/urlReplaceSettings.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/2.php,importbuddy/controllers/ajax/2.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/2.php,importbuddy/controllers/ajax/2.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/4.php,importbuddy/controllers/ajax/4.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/4.php,importbuddy/controllers/ajax/4.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/5.php,importbuddy/controllers/ajax/5.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/5.php,importbuddy/controllers/ajax/5.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/6.php,importbuddy/controllers/ajax/6.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CkF1dGg6OnJlcXVpcmVfYXV0aGVudGljYXRpb24oKTsgLy8gRGllIGlmIG5vdCBsb2dnZWQgaW4uCnBiX2JhY2t1cGJ1ZGR5Ojpsb2FkX3ZpZXcoICdfaWZyYW1lX2hlYWRlcicpOwpwYl9iYWNrdXBidWRkeTo6c2V0X2dyZWVkeV9zY3JpcHRfbGltaXRzKCk7CmVjaG8gIjxzY3JpcHQ+cGFnZVRpdGxlKCAnU3RlcCA2OiBDbGVhbnVwICYgQ29tcGxldGlvbicgKTs8L3NjcmlwdD4iOwplY2hvICI8c2NyaXB0PmJiX3Nob3dTdGVwKCAnY2xlYW51cFNldHRpbmdzJyApOzwvc2NyaXB0PiI7CnBiX2JhY2t1cGJ1ZGR5OjpmbHVzaCgpOwoKCmlmICggJ3RydWUnICE9IHBiX2JhY2t1cGJ1ZGR5OjpfR0VUKCAnZGVwbG95JyApICkgeyAvLyBkZXBsb3ltZW50IG1vZGUgcHJlLWxvYWRzIHN0YXRlIGRhdGEgaW4gYSBmaWxlIGluc3RlYWQgb2YgcGFzc2luZyB2aWEgcG9zdC4KCS8vIFBhcnNlIHN1Ym1pdHRlZCByZXN0b3JlRGF0YSByZXN0b3JlIHN0YXRlIGZyb20gcHJldmlvdXMgc3RlcC4KCSRyZXN0b3JlRGF0YSA9IHBiX2JhY2t1cGJ1ZGR5OjpfUE9TVCggJ3Jlc3RvcmVEYXRhJyApOwoJCgkKCS8vIERlY29kZSBzdWJtaXR0ZWQgZGF0YSwgcmVwb3J0aW5nIGRldGFpbHMgb24gZmFpbHVyZS4KCSRkZWNvZGVGYWlsUmVhc29uID0gJyc7CglpZiAoIGZhbHNlID09PSAoICRyZXN0b3JlRGF0YSA9IGJhc2U2NF9kZWNvZGUoICRyZXN0b3JlRGF0YSApICkgKSB7IC8vIGZhbHNlIGlmIGZhaWxlZAoJCSRkZWNvZGVGYWlsUmVhc29uID0gJ0VSUk9SICM4Mzg5M2I6IFJlc3RvcmUgaGFsdGVkLiBVbmFibGUgdG8gYmFzZTY0X2RlY29kZSgpIHN1Ym1pdHRlZCBmb3JtIGRhdGEgYCcgLiBodG1sZW50aXRpZXMoIHBiX2JhY2t1cGJ1ZGR5OjpfUE9TVCggJ3Jlc3RvcmVEYXRhJyApICkgLiAnYC4nOwoJfSBlbHNlIHsgLy8gU3VjY2Vzcy4KCQkkcmVzdG9yZURhdGEgPSB1cmxkZWNvZGUoICRyZXN0b3JlRGF0YSApOwoJCWlmICggbnVsbCA9PT0gKCAkcmVzdG9yZURhdGEgPSBqc29uX2RlY29kZSggJHJlc3RvcmVEYXRhLCB0cnVlICkgKSApIHsgLy8gbnVsbCBpZiBmYWlsZWQKCQkJJG1lc3NhZ2UgPSAnRVJST1IgIzgzODkzYzogUmVzdG9yZSBoYWx0ZWQuIFVuYWJsZSB0byBkZWNvZGUgSlNPTiByZXN0b3JlIGJhc2U2NCBkZWNvZGVkIGRhdGEgYCcgLiBodG1sZW50aXRpZXMoIGJhc2U2NF9kZWNvZGUoIHBiX2JhY2t1cGJ1ZGR5OjpfUE9TVCggJ3Jlc3RvcmVEYXRhJyApICkgKSAuICdgLiBCZWZvcmUgYmFzZTY0IGRlY29kZTogYCcgLiBodG1sZW50aXRpZXMoIHBiX2JhY2t1cGJ1ZGR5OjpfUE9TVCggJ3Jlc3RvcmVEYXRhJyApICkgLiAnYC4nOwoJCQlpZiAoIGZ1bmN0aW9uX2V4aXN0cyggJ2pzb25fbGFzdF9lcnJvcicgKSApIHsKCQkgCQkkbWVzc2FnZSAuPSAnIGpzb25fbGFzdF9lcnJvcjogYCcgLiBqc29uX2xhc3RfZXJyb3IoKSAuICdgLic7CgkJIAl9CgkJIAkkZGVjb2RlRmFpbFJlYXNvbiA9ICRtZXNzYWdlOwoJCX0gZWxzZSB7IC8vIFN1Y2Nlc3MuCgkJCXBiX2JhY2t1cGJ1ZGR5OjpzdGF0dXMoICdkZXRhaWxzJywgJ1N1Y2Nlc3MgZGVjb2Rpbmcgc3VibWl0dGVkIGVuY29kZWQgZGF0YS4nICk7CgkJfQoJfQoJLy8gUmVwb3J0IGZhaWx1cmUgYW5kIGZhdGFsbHkgaGFsdC4KCWlmICggJycgIT09ICRkZWNvZGVGYWlsUmVhc29uICkgewoJCXBiX2JhY2t1cGJ1ZGR5OjphbGVydCggJG1lc3NhZ2UgKTsKCQlwYl9iYWNrdXBidWRkeTo6c3RhdHVzKCAnZXJyb3InLCAkbWVzc2FnZSApOwoJCWRpZSgpOwoJfQoJCgkKfSBlbHNlIHsKCWlmICggaXNzZXQoIHBiX2JhY2t1cGJ1ZGR5Ojokb3B0aW9uc1snZGVmYXVsdF9zdGF0ZV9vdmVycmlkZXMnXSApICYmICggY291bnQoIHBiX2JhY2t1cGJ1ZGR5Ojokb3B0aW9uc1snZGVmYXVsdF9zdGF0ZV9vdmVycmlkZXMnXSApID4gMCApICkgeyAvLyBEZWZhdWx0IHN0YXRlIG92ZXJyaWRlcyBleGlzdC4gQXBwbHkgdGhlbS4KCQkkcmVzdG9yZURhdGEgPSBwYl9iYWNrdXBidWRkeTo6JG9wdGlvbnNbJ2RlZmF1bHRfc3RhdGVfb3ZlcnJpZGVzJ107CgkJCgkJLyoKCQllY2hvICc8cHJlPic7CgkJcHJpbnRfciggJHJlc3RvcmVEYXRhICk7CgkJZWNobyAnPC9wcmU+JzsKCQkqLwoJfSBlbHNlIHsKCQlkaWUoICdFcnJvciAjMzI3ODMyMTogTWlzc2luZyBleHBlY3RlZCBkZWZhdWx0IHN0YXRlIG92ZXJyaWRlLicgKTsKCX0KfQoKCi8vIEluc3RhbnRpYXRlIHJlc3RvcmUgY2xhc3MuCnJlcXVpcmVfb25jZSggcGJfYmFja3VwYnVkZHk6OnBsdWdpbl9wYXRoKCkgLiAnL2NsYXNzZXMvcmVzdG9yZS5waHAnICk7CiRyZXN0b3JlID0gbmV3IGJhY2t1cGJ1ZGR5X3Jlc3RvcmUoICdyZXN0b3JlJywgJHJlc3RvcmVEYXRhICk7CnVuc2V0KCAkcmVzdG9yZURhdGEgKTsgLy8gQWNjZXNzIHZpYSAkcmVzdG9yZS0+X3N0YXRlIHRvIG1ha2Ugc3VyZSBpdCBpcyBhbHdheXMgdXAgdG8gZGF0ZS4KaWYgKCAndHJ1ZScgIT0gcGJfYmFja3VwYnVkZHk6Ol9HRVQoICdkZXBsb3knICkgKSB7IC8vIFdlIGRvbnQgYWNjZXB0IHN1Ym1pdHRlZCBmb3JtIG9wdGlvbnMgZHVyaW5nIGRlcGxveS4KCSRyZXN0b3JlLT5fc3RhdGUgPSBwYXJzZV9vcHRpb25zKCAkcmVzdG9yZS0+X3N0YXRlICk7Cn0gZWxzZSB7IC8vIERlcGxveW1lbnQgc2hvdWxkIHNsZWVwIHRvIGhlbHAgZ2l2ZSB0aW1lIGZvciB0aGUgc291cmNlIHNpdGUgdG8gZ3JhYiB0aGUgbGFzdCBzdGF0dXMgbG9nLgoJc2xlZXAoIDUgKTsKfQoKJGZvb3RlciA9IGZpbGVfZ2V0X2NvbnRlbnRzKCBwYl9iYWNrdXBidWRkeTo6JF9wbHVnaW5fcGF0aCAuICcvdmlld3MvX2lmcmFtZV9mb290ZXIucGhwJyApOwoKaWYgKCAndHJ1ZScgPT0gcGJfYmFja3VwYnVkZHk6Ol9HRVQoICdkZXBsb3knICkgKSB7CgllY2hvICc8aDU+RmluaXNoZWQgZGVwbG95aW5nIHB1c2hlZCBkYXRhICYgdGVtcG9yYXJ5IGZpbGUgY2xlYW51cC48L2g1Pic7Cn0KZWNobyAiPHNjcmlwdD5iYl9zaG93U3RlcCggJ2ZpbmlzaGVkJywgIiAuIGpzb25fZW5jb2RlKCAkcmVzdG9yZS0+X3N0YXRlICkgLiAiICk7PC9zY3JpcHQ+IjsKCgovLyBSZXBsYWNlcyBzbGVlcGluZyA2IHNlY29uZHMuIE1vcmUgcmVsaWFibGUgYnV0IHVzZXMgbG90cyBvZiBDUFUuCiRzdG9wX3RpbWVfbGltaXQgPSA2OwpwYl9iYWNrdXBidWRkeTo6c3RhdHVzKCAnZGV0YWlscycsICdCZWdnaW5pbmcgYCcgLiAkc3RvcF90aW1lX2xpbWl0IC4gJ2Agc2Vjb25kIHNsZWVwIHdoaWxlIGZpbGVzIGRlbGV0ZS4nICk7CnBiX2JhY2t1cGJ1ZGR5OjpmbHVzaCggdHJ1ZSApOwokdCA9IDA7IC8vIFRpbWUgPSAwOwp3aGlsZSggJHQgPCAkc3RvcF90aW1lX2xpbWl0ICkgewoJJG5vdyA9IHRpbWUoKTsKCXdoaWxlICggdGltZSgpIDwgKCAkbm93ICsgMSApICkgeyB0cnVlOyB9CgkkdCsrOwp9CgppZiAoICcnICE9PSAkcmVzdG9yZS0+X3N0YXRlWydjbGVhbnVwJ11bJ3NldF9ibG9nX3B1YmxpYyddICkgewoJcGJfYmFja3VwYnVkZHk6OnN0YXR1cyggJ2RldGFpbHMnLCAnQ2hhbmdpbmcgYmxvZ19wdWJsaWMgc2VhcmNoIGVuZ2luZSB2aXNpYmlsaXR5IGJhc2VkIG9uIHNlbGVjdGVkIHNldHRpbmcgd2l0aCB2YWx1ZSBgJyAuICRyZXN0b3JlLT5fc3RhdGVbJ2NsZWFudXAnXVsnc2V0X2Jsb2dfcHVibGljJ10gLiAnYC4nICk7CgkkcmVzdG9yZS0+c2V0QmxvZ1B1YmxpYyggJHJlc3RvcmUtPl9zdGF0ZVsnY2xlYW51cCddWydzZXRfYmxvZ19wdWJsaWMnXSApOwp9IGVsc2UgewoJcGJfYmFja3VwYnVkZHk6OnN0YXR1cyggJ2RldGFpbHMnLCAnTm8gY2hhbmdlIHRvIGJsb2dfcHVibGljIHNlYXJjaCBlbmdpbmUgdmlzaWJpbGl0eSBiYXNlZCBvbiBzZWxlY3RlZCBzZXR0aW5nLicgKTsKfQoKaWYgKCAndHJ1ZScgPT0gcGJfYmFja3VwYnVkZHk6Ol9HRVQoICdkZXBsb3knICkgKSB7IC8vIERlcGxveW1lbnQKCXBiX2JhY2t1cGJ1ZGR5OjpzdGF0dXMoICdkZXRhaWxzJywgJ0RlcGxveW1lbnQgc28gc2tpcHBpbmcgY2xlYW51cCBwcm9jZWR1cmVzLicgKTsKfSBlbHNlIHsKCWNsZWFudXAoICRyZXN0b3JlLT5fc3RhdGUsICRyZXN0b3JlICk7Cn0KZWNobyAkZm9vdGVyOyAvLyBXZSBtdXN0IHByZWxvYWQgdGhlIGZvb3RlciBmaWxlIGNvbnRlbnRzIHNpbmNlIHdlIGFyZSBhYm91dCB0byBkZWxldGUgaXQuCgoKaWYgKCAndHJ1ZScgPT0gcGJfYmFja3VwYnVkZHk6Ol9HRVQoICdkZXBsb3knICkgKSB7IC8vIERlcGxveW1lbnQKCXBiX2JhY2t1cGJ1ZGR5OjpzdGF0dXMoICdtZXNzYWdlJywgJ0RlcGxveW1lbnQgZmluaXNoZWQgKGltcG9ydGJ1ZGR5KS4nICk7CglwYl9iYWNrdXBidWRkeTo6c3RhdHVzKCAnZGVwbG95RmluaXNoZWQnLCAnRmluaXNoZWQuJyApOwp9IGVsc2UgeyAvLyBTdGFuZGFyZCByZXN0b3JlLgoJcGJfYmFja3VwYnVkZHk6OnN0YXR1cyggJ2JhY2t1cGJ1ZGR5X21pbGVzdG9uZScsICdmaW5pc2hfaW1wb3J0YnVkZHknICk7Cn0KCgovLyBQYXJzZSBzdWJtaXR0ZWQgb3B0aW9ucy9zZXR0aW5ncy4KZnVuY3Rpb24gcGFyc2Vfb3B0aW9ucyggJHJlc3RvcmVEYXRhICkgewoJCglpZiAoICcxJyA9PSBwYl9iYWNrdXBidWRkeTo6X1BPU1QoICdkZWxldGVfYmFja3VwJyApICkgewoJCSRyZXN0b3JlRGF0YVsnY2xlYW51cCddWydkZWxldGVBcmNoaXZlJ10gPSB0cnVlOwoJfSBlbHNlIHsKCQkkcmVzdG9yZURhdGFbJ2NsZWFudXAnXVsnZGVsZXRlQXJjaGl2ZSddID0gZmFsc2U7Cgl9CgkKCWlmICggJzEnID09IHBiX2JhY2t1cGJ1ZGR5OjpfUE9TVCggJ2RlbGV0ZV90ZW1wJyApICkgewoJCSRyZXN0b3JlRGF0YVsnY2xlYW51cCddWydkZWxldGVUZW1wRmlsZXMnXSA9IHRydWU7Cgl9IGVsc2UgewoJCSRyZXN0b3JlRGF0YVsnY2xlYW51cCddWydkZWxldGVUZW1wRmlsZXMnXSA9IGZhbHNlOwoJfQoJCglpZiAoICcxJyA9PSBwYl9iYWNrdXBidWRkeTo6X1BPU1QoICdkZWxldGVfaW1wb3J0YnVkZHknICkgKSB7CgkJJHJlc3RvcmVEYXRhWydjbGVhbnVwJ11bJ2RlbGV0ZUltcG9ydEJ1ZGR5J10gPSB0cnVlOwoJfSBlbHNlIHsKCQkkcmVzdG9yZURhdGFbJ2NsZWFudXAnXVsnZGVsZXRlSW1wb3J0QnVkZHknXSA9IGZhbHNlOwoJfQoJCglpZiAoICcxJyA9PSBwYl9iYWNrdXBidWRkeTo6X1BPU1QoICdkZWxldGVfaW1wb3J0YnVkZHlfZGlyZWN0b3J5JyApICkgewoJCSRyZXN0b3JlRGF0YVsnY2xlYW51cCddWydkZWxldGVJbXBvcnRCdWRkeURpcmVjdG9yeSddID0gdHJ1ZTsKCX0gZWxzZSB7CgkJJHJlc3RvcmVEYXRhWydjbGVhbnVwJ11bJ2RlbGV0ZUltcG9ydEJ1ZGR5RGlyZWN0b3J5J10gPSBmYWxzZTsKCX0KCQoJaWYgKCAnMScgPT0gcGJfYmFja3VwYnVkZHk6Ol9QT1NUKCAnZGVsZXRlX2ltcG9ydGJ1ZGR5bG9nJyApICkgewoJCSRyZXN0b3JlRGF0YVsnY2xlYW51cCddWydkZWxldGVJbXBvcnRMb2cnXSA9IHRydWU7Cgl9IGVsc2UgewoJCSRyZXN0b3JlRGF0YVsnY2xlYW51cCddWydkZWxldGVJbXBvcnRMb2cnXSA9IGZhbHNlOwoJfQoJCgkvLyBTZWFyY2ggZW5naW5lIHZpc2liaWxpdHkgKHNldF9ibG9nX3B1YmxpYyB3cF9vcHRpb25zKS4KCWlmICggJzEnID09IHBiX2JhY2t1cGJ1ZGR5OjpfUE9TVCggJ3NldF9ibG9nX3B1YmxpYycgKSApIHsKCQkkcmVzdG9yZURhdGFbJ2NsZWFudXAnXVsnc2V0X2Jsb2dfcHVibGljJ10gPSB0cnVlOwoJfSBlbHNlaWYgKCAnMCcgPT0gcGJfYmFja3VwYnVkZHk6Ol9QT1NUKCAnc2V0X2Jsb2dfcHVibGljJyApICkgewoJCSRyZXN0b3JlRGF0YVsnY2xlYW51cCddWydzZXRfYmxvZ19wdWJsaWMnXSA9IGZhbHNlOwoJfQoJCglyZXR1cm4gJHJlc3RvcmVEYXRhOwp9CgoKLyoJY2xlYW51cCgpCiAqCQogKglDbGVhbnMgdXAgYW55IHRlbXBvcmFyeSBmaWxlcyBsZWZ0IGJ5IGltcG9ydGJ1ZGR5LgogKgkKICoJQHJldHVybgkJbnVsbAogKi8KZnVuY3Rpb24gY2xlYW51cCggJHJlc3RvcmVEYXRhLCAkcmVzdG9yZSApIHsKCXBiX2JhY2t1cGJ1ZGR5OjpzdGF0dXMoICdkZXRhaWxzJywgJ1N0YXJ0aW5nIGltcG9ydGJ1ZGR5IGNsZWFudXAgcHJvY2VkdXJlcy4nICk7CgkKCS8vIEFsd2F5cyBkZWxldGUgYW55IGFyY2hpdmUgcHJpbWVyIGZpbGUgKC5pdGJ1YikgYXMgbm8gcHVycG9zZSB0byByZXRhaW4gaXQKCXJlbW92ZV9maWxlKCBBQlNQQVRIIC4gJy5pdGJ1YicsICcuaXRidWIgKGFyY2hpdmUgcHJpbWVyIGZpbGUpJywgZmFsc2UgKTsKCQoJaWYgKCB0cnVlICE9PSAkcmVzdG9yZURhdGFbJ2NsZWFudXAnXVsnZGVsZXRlQXJjaGl2ZSddICkgewoJCXBiX2JhY2t1cGJ1ZGR5OjpzdGF0dXMoICdkZXRhaWxzJywgJ1NraXBwZWQgZGVsZXRpbmcgYmFja3VwIGFyY2hpdmUuJyApOwoJfSBlbHNlIHsKCQlyZW1vdmVfZmlsZSggJHJlc3RvcmVEYXRhWydhcmNoaXZlJ10sICdiYWNrdXAgLlpJUCBmaWxlICgnIC4gJHJlc3RvcmVEYXRhWydhcmNoaXZlJ10gLiAnKScsIHRydWUgKTsKCX0KCQoJaWYgKCB0cnVlICE9PSAkcmVzdG9yZURhdGFbJ2NsZWFudXAnXVsnZGVsZXRlVGVtcEZpbGVzJ10gKSB7CgkJcGJfYmFja3VwYnVkZHk6OnN0YXR1cyggJ2RldGFpbHMnLCAnU2tpcHBlZCBkZWxldGluZyB0ZW1wb3JhcnkgZmlsZXMuJyApOwoJfSBlbHNlIHsKCQkvLyBGdWxsIGJhY2t1cCAuc3FsIGZpbGUKCQlyZW1vdmVfZmlsZSggQUJTUEFUSCAuICd3cC1jb250ZW50L3VwbG9hZHMvdGVtcF8nLiAkcmVzdG9yZURhdGFbJ3NlcmlhbCddIC4nL2RiLnNxbCcsICdkYi5zcWwgKGJhY2t1cCBkYXRhYmFzZSBkdW1wKScsIGZhbHNlICk7CgkJcmVtb3ZlX2ZpbGUoIEFCU1BBVEggLiAnd3AtY29udGVudC91cGxvYWRzL3RlbXBfJy4gJHJlc3RvcmVEYXRhWydzZXJpYWwnXSAuJy9kYl8xLnNxbCcsICdkYl8xLnNxbCAoYmFja3VwIGRhdGFiYXNlIGR1bXApJywgZmFsc2UgKTsKCQlyZW1vdmVfZmlsZSggQUJTUEFUSCAuICd3cC1jb250ZW50L3VwbG9hZHMvYmFja3VwYnVkZHlfdGVtcC8nLiAkcmVzdG9yZURhdGFbJ3NlcmlhbCddIC4nL2RiXzEuc3FsJywgJ2RiXzEuc3FsIChiYWNrdXAgZGF0YWJhc2UgZHVtcCknLCBmYWxzZSApOwoJCS8vIERCIG9ubHkgc3FsIGZpbGUKCQlyZW1vdmVfZmlsZSggQUJTUEFUSCAuICdkYi5zcWwnLCAnZGIuc3FsIChiYWNrdXAgZGF0YWJhc2UgZHVtcCknLCBmYWxzZSApOwoJCXJlbW92ZV9maWxlKCBBQlNQQVRIIC4gJ2RiXzEuc3FsJywgJ2RiXzEuc3FsIChiYWNrdXAgZGF0YWJhc2UgZHVtcCknLCBmYWxzZSApOwoJCQoJCS8vIEZ1bGwgYmFja3VwIGRhdCBmaWxlCgkJcmVtb3ZlX2ZpbGUoIEFCU1BBVEggLiAnd3AtY29udGVudC91cGxvYWRzL3RlbXBfJyAuICRyZXN0b3JlRGF0YVsnc2VyaWFsJ10gLiAnL2JhY2t1cGJ1ZGR5X2RhdC5waHAnLCAnYmFja3VwYnVkZHlfZGF0LnBocCAoYmFja3VwIGRhdGEgZmlsZSknLCBmYWxzZSApOwoJCXJlbW92ZV9maWxlKCBBQlNQQVRIIC4gJ3dwLWNvbnRlbnQvdXBsb2Fkcy9iYWNrdXBidWRkeV90ZW1wLycgLiAkcmVzdG9yZURhdGFbJ3NlcmlhbCddIC4gJy9iYWNrdXBidWRkeV9kYXQucGhwJywgJ2JhY2t1cGJ1ZGR5X2RhdC5waHAgKGJhY2t1cCBkYXRhIGZpbGUpJywgZmFsc2UgKTsKCQkvLyBEQiBvbmx5IGRhdCBmaWxlCgkJcmVtb3ZlX2ZpbGUoIEFCU1BBVEggLiAnYmFja3VwYnVkZHlfZGF0LnBocCcsICdiYWNrdXBidWRkeV9kYXQucGhwIChiYWNrdXAgZGF0YSBmaWxlKScsIGZhbHNlICk7CgkJCgkJcmVtb3ZlX2ZpbGUoIEFCU1BBVEggLiAnd3AtY29udGVudC91cGxvYWRzL2JhY2t1cGJ1ZGR5X3RlbXAvJyAuICRyZXN0b3JlRGF0YVsnc2VyaWFsJ10gLiAnLycsICdUZW1wb3JhcnkgYmFja3VwIGRpcmVjdG9yeScsIGZhbHNlICk7CgkJCgkJLy8gVGVtcCByZXN0b3JlIGRpci4KCQlyZW1vdmVfZmlsZSggQUJTUEFUSCAuICdpbXBvcnRidWRkeS90ZW1wXycuICRyZXN0b3JlRGF0YVsnc2VyaWFsJ10gLicvJywgJ1RlbXBvcmFyeSByZXN0b3JlIGRpcmVjdG9yeScsIGZhbHNlICk7CgkJCgkJLy8gUmVtb3ZlIHN0YXRlIGZpbGUgKGRlcGxveW1lbnQvZGVmYXVsdCBzZXR0aW5ncykuCgkJZ2xvYmFsICRpbXBvcnRidWRkeV9maWxlOwoJCSRpbXBvcnRGaWxlU2VyaWFsID0gYmFja3VwYnVkZHlfY29yZTo6Z2V0X3NlcmlhbF9mcm9tX2ZpbGUoICRpbXBvcnRidWRkeV9maWxlICk7CgkJJHN0YXRlX2ZpbGUgPSBBQlNQQVRIIC4gJ2ltcG9ydGJ1ZGR5LScgLiAkaW1wb3J0RmlsZVNlcmlhbCAuICctc3RhdGUucGhwJzsKCQlyZW1vdmVfZmlsZSggJHN0YXRlX2ZpbGUsICdEZWZhdWx0IHN0YXRlIGRhdGEgZmlsZScsIGZhbHNlICk7Cgl9CgkKCWdsb2JhbCAkaW1wb3J0YnVkZHlfZmlsZTsKCWlmICggdHJ1ZSAhPT0gJHJlc3RvcmVEYXRhWydjbGVhbnVwJ11bJ2RlbGV0ZUltcG9ydEJ1ZGR5J10gKSB7CgkJcGJfYmFja3VwYnVkZHk6OnN0YXR1cyggJ2RldGFpbHMnLCAnU2tpcHBlZCBkZWxldGluZyAnIC4gJGltcG9ydGJ1ZGR5X2ZpbGUgLiAnICh0aGlzIHNjcmlwdCkuJyApOwoJfSBlbHNlIHsKCQlyZW1vdmVfZmlsZSggQUJTUEFUSCAuICRpbXBvcnRidWRkeV9maWxlLCAkaW1wb3J0YnVkZHlfZmlsZSAuICcgKHRoaXMgc2NyaXB0KScsIHRydWUgKTsKCX0KCQoJaWYgKCB0cnVlICE9PSAkcmVzdG9yZURhdGFbJ2NsZWFudXAnXVsnZGVsZXRlSW1wb3J0QnVkZHlEaXJlY3RvcnknXSApIHsKCQlwYl9iYWNrdXBidWRkeTo6c3RhdHVzKCAnZGV0YWlscycsICdTa2lwcGVkIGRlbGV0aW5nIGltcG9ydGJ1ZGR5IGRpcmVjdG9yeS4nICk7Cgl9IGVsc2UgewoJCXJlbW92ZV9maWxlKCBBQlNQQVRIIC4gJ2ltcG9ydGJ1ZGR5LycsICdJbXBvcnRCdWRkeSBEaXJlY3RvcnknLCB0cnVlICk7CgkJcmVtb3ZlX2ZpbGUoIEFCU1BBVEggLiAnaW1wb3J0YnVkZHkvX3NldHRpbmdzX2RhdC5waHAnLCAnX3NldHRpbmdzX2RhdC5waHAgKHRlbXBvcmFyeSBzZXR0aW5ncyBmaWxlKScsIGZhbHNlICk7Cgl9CgkKCS8vIERlbGV0ZSBsb2cgZmlsZSBsYXN0LgoJaWYgKCB0cnVlICE9PSAkcmVzdG9yZURhdGFbJ2NsZWFudXAnXVsnZGVsZXRlSW1wb3J0TG9nJ10gKSB7CgkJcGJfYmFja3VwYnVkZHk6OnN0YXR1cyggJ2RldGFpbHMnLCAnU2tpcHBlZCBkZWxldGluZyBpbXBvcnQgbG9nIChkZWxldGVJbXBvcnRCdWRkeURpcmVjdG9yeSBtYXkgb3ZlcnJpZGUpLicgKTsKCX0gZWxzZSB7CgkJcmVtb3ZlX2ZpbGUoIEFCU1BBVEggLiAnaW1wb3J0YnVkZHktJyAuIHBiX2JhY2t1cGJ1ZGR5Ojokb3B0aW9uc1snbG9nX3NlcmlhbCddIC4gJy50eHQnLCAnaW1wb3J0YnVkZHktJyAuIHBiX2JhY2t1cGJ1ZGR5Ojokb3B0aW9uc1snbG9nX3NlcmlhbCddIC4gJy50eHQgbG9nIGZpbGUnLCB0cnVlICk7Cgl9Cn0KCgoKCgovLyBVc2VkIGJ5IGNsZWFudXAoKSBhYm92ZS4KZnVuY3Rpb24gcmVtb3ZlX2ZpbGUoICRmaWxlLCAkZGVzY3JpcHRpb24sICRlcnJvcl9vbl9taXNzaW5nID0gZmFsc2UgKSB7CglwYl9iYWNrdXBidWRkeTo6c3RhdHVzKCAnbWVzc2FnZScsICdEZWxldGluZyBgJyAuICRkZXNjcmlwdGlvbiAuICdgLi4uJyApOwoKCSRtb2RlID0gYXBwbHlfZmlsdGVycyggJ2l0YnViLWRlZmF1bHQtZmlsZS1tb2RlJywgMDc1NSApOwoJQGNobW9kKCAkZmlsZSwgJG1vZGUgKTsgLy8gSGlnaCBwZXJtaXNzaW9ucyB0byBkZWxldGUuCgkKCWlmICggaXNfZGlyKCAkZmlsZSApICkgeyAvLyBkaXJlY3RvcnkuCgkJcGJfYmFja3VwYnVkZHk6OiRmaWxlc3lzdGVtLT51bmxpbmtfcmVjdXJzaXZlKCAkZmlsZSApOwoJCWlmICggZmlsZV9leGlzdHMoICRmaWxlICkgKSB7CgkJCXBiX2JhY2t1cGJ1ZGR5OjpzdGF0dXMoICdlcnJvcicsICdVbmFibGUgdG8gZGVsZXRlIGRpcmVjdG9yeTogYCcgLiAkZGVzY3JpcHRpb24gLiAnYC4gWW91IHNob3VsZCBtYW51YWxseSBkZWxldGUgaXQuJyApOwoJCX0gZWxzZSB7CgkJCXBiX2JhY2t1cGJ1ZGR5OjpzdGF0dXMoICdtZXNzYWdlJywgJ0RlbGV0ZWQuJywgZmFsc2UgKTsgLy8gTm8gbG9nZ2luZyBvZiB0aGlzIGFjdGlvbiB0byBwcmV2ZW50IHJlY3JlYXRpbmcgbG9nLgoJCX0KCX0gZWxzZSB7IC8vIGZpbGUKCQlpZiAoIGZpbGVfZXhpc3RzKCAkZmlsZSApICkgewoJCQlpZiAoIHRydWUgIT09IEB1bmxpbmsoICRmaWxlICkgKSB7CgkJCQlwYl9iYWNrdXBidWRkeTo6c3RhdHVzKCAnZXJyb3InLCAnVW5hYmxlIHRvIGRlbGV0ZSBmaWxlOiBgJyAuICRkZXNjcmlwdGlvbiAuICdgLiBZb3Ugc2hvdWxkIG1hbnVhbGx5IGRlbGV0ZSBpdC4nICk7CgkJCX0gZWxzZSB7CgkJCQlwYl9iYWNrdXBidWRkeTo6c3RhdHVzKCAnbWVzc2FnZScsICdEZWxldGVkLicsIGZhbHNlICk7IC8vIE5vIGxvZ2dpbmcgb2YgdGhpcyBhY3Rpb24gdG8gcHJldmVudCByZWNyZWF0aW5nIGxvZy4KCQkJfQoJCX0KCX0KfSAvLyBFbmQgcmVtb3ZlX2ZpbGUoKS4KCgpkaWUoKTsgLy8gRG9uJ3Qgd2FudCB0byBhY2NpZGVudGx5IGdvIGJhY2sgdG8gYW55IGZpbGVzIHdoaWNoIG1heSBiZSBnb25lLgoK
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/6.php,importbuddy/controllers/ajax/6.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/cpanel_createdb.php,importbuddy/controllers/ajax/cpanel_createdb.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CgpBdXRoOjpyZXF1aXJlX2F1dGhlbnRpY2F0aW9uKCk7IC8vIERpZSBpZiBub3QgbG9nZ2VkIGluLgoKLy9wcmludF9yKCBwYl9iYWNrdXBidWRkeTo6X1BPU1QoKSApOwoKJGNwYW5lbF91c2VyID0gcGJfYmFja3VwYnVkZHk6Ol9QT1NUKCAnY3BhbmVsX3VzZXInICk7CiRjcGFuZWxfcGFzc3dvcmQgPSBwYl9iYWNrdXBidWRkeTo6X1BPU1QoICdjcGFuZWxfcGFzcycgKTsKJGNwYW5lbF9ob3N0ID0gcGJfYmFja3VwYnVkZHk6Ol9QT1NUKCAnY3BhbmVsX3VybCcgKTsKJGNwYW5lbF9wb3J0ID0gcGJfYmFja3VwYnVkZHk6Ol9QT1NUKCAnY3BhbmVsX3BvcnQnICk7CiRjcGFuZWxfcHJvdG9jb2wgPSBwYl9iYWNrdXBidWRkeTo6X1BPU1QoICdjcGFuZWxfcHJvdG9jb2wnICk7CiRkYl9uYW1lID0gcGJfYmFja3VwYnVkZHk6Ol9QT1NUKCAnY3BhbmVsX2RibmFtZScgKTsKJGRiX3VzZXIgPSBwYl9iYWNrdXBidWRkeTo6X1BPU1QoICdjcGFuZWxfZGJ1c2VyJyApOwokZGJfcGFzcyA9IHBiX2JhY2t1cGJ1ZGR5OjpfUE9TVCggJ2NwYW5lbF9kYnBhc3MnICk7CgovLyBOZWVkZWQgZm9yIEhUVFAgcmVxdWVzdHMuCiRyZXF1ZXN0Y29yZV9maWxlID0gcGJfYmFja3VwYnVkZHk6OnBsdWdpbl9wYXRoKCkgLiAnL2xpYi9yZXF1ZXN0Y29yZS9yZXF1ZXN0Y29yZS5jbGFzcy5waHAnOwpyZXF1aXJlX29uY2UoICRyZXF1ZXN0Y29yZV9maWxlICk7CgpyZXF1aXJlX29uY2UoIHBiX2JhY2t1cGJ1ZGR5OjpwbHVnaW5fcGF0aCgpIC4gJy9saWIvY3BhbmVsL2NwYW5lbC5waHAnICk7CiRjcmVhdGVfZGJfcmVzdWx0ID0gcGJfYmFja3VwYnVkZHlfY3BhbmVsOjpjcmVhdGVfZGIoICRjcGFuZWxfdXNlciwgJGNwYW5lbF9wYXNzd29yZCwgJGNwYW5lbF9ob3N0LCAkZGJfbmFtZSwgJGRiX3VzZXIsICRkYl9wYXNzLCAkY3BhbmVsX3BvcnQsICRjcGFuZWxfcHJvdG9jb2wgKTsKCmlmICggJGNyZWF0ZV9kYl9yZXN1bHQgPT09IHRydWUgKSB7CgllY2hvICdTdWNjZXNzISBDcmVhdGVkIGRhdGFiYXNlLCB1c2VyLCBhbmQgYXNzaWduZWQgdXNlciB0byBkYXRhYmFzZS4nOwp9IGVsc2UgewoJZWNobyAiVW5hYmxlIHRvIGF1dG9tYXRpY2FsbHkgY3JlYXRlIGRhdGFiYXNlIHdpdGggdGhlIHByb3ZpZGVkIHNldHRpbmdzLiBDaGVjayBzZXR0aW5ncyBvciBtYW51YWxseSBjcmVhdGUgdGhlIGRhdGFiYXNlIGZyb20geW91ciBob3N0J3MgY29udHJvbCBwYW5lbC4gU2VlIHR1dG9yaWFsIGF0OiAiOwoJZWNobyAiaHR0cDovL2l0aGVtZXMuY29tL3R1dG9yaWFsLWNyZWF0ZS1kYXRhYmFzZS1pbi1jcGFuZWwvXG5cbiI7CgllY2hvICJFcnJvciBkZXRhaWxzOlxuIiAuIGltcGxvZGUoICJcbiIsICRjcmVhdGVfZGJfcmVzdWx0KTsKfQoKZGllKCk7Cg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/cpanel_createdb.php,importbuddy/controllers/ajax/cpanel_createdb.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/file_hash.php,importbuddy/controllers/ajax/file_hash.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CkF1dGg6OnJlcXVpcmVfYXV0aGVudGljYXRpb24oKTsgLy8gRGllIGlmIG5vdCBsb2dnZWQgaW4uCgokZmlsZSA9IEFCU1BBVEggLiBwYl9iYWNrdXBidWRkeTo6X1BPU1QoICdmaWxlJyApOwoKaWYgKCAnJyA9PSAkZmlsZSApIHsKCWRpZSggJ05vIGZpbGUgcGFzc2VkLicgKTsKfQppZiAoICEgZmlsZV9leGlzdHMoICRmaWxlICkgKSB7CglkaWUoICdGaWxlIG5vdCBmb3VuZC4nICk7Cn0KCiRmaWxlSGFzaCA9IEBtZDVfZmlsZSggJGZpbGUgKTsKCmlmICggZmFsc2UgPT09ICRmaWxlSGFzaCApIHsKCWRpZSggJ1VuYWJsZSB0byBjYWxjdWxhdGUgaGFzaC4gVmVyaWZ5IGZpbGUgcGVybWlzc2lvbnMuJyApOwp9IGVsc2UgewoJZGllKCBqc29uX2VuY29kZSggYXJyYXkoICdoYXNoJyA9PiAkZmlsZUhhc2ggKSApICk7Cn0=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/file_hash.php,importbuddy/controllers/ajax/file_hash.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/getDeployLog.php,importbuddy/controllers/ajax/getDeployLog.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CgppZiAoICd0cnVlJyAhPSBwYl9iYWNrdXBidWRkeTo6X0dFVCggJ2RlcGxveScgKSApIHsKCWRpZSggJ0FjY2VzcyBkZW5pZWQuJyApOwp9CgovLyBPbmx5IGFsbG93IGFjY2VzcyB0byB0aGlzIGZpbGUgaWYgaXQgaGFzIGEgc2VyaWFsIGhpZGluZyBpdC4gVXNlZCBieSBkZXBsb3ltZW50LgpnbG9iYWwgJGltcG9ydGJ1ZGR5X2ZpbGU7CiRpbXBvcnRGaWxlU2VyaWFsID0gYmFja3VwYnVkZHlfY29yZTo6Z2V0X3NlcmlhbF9mcm9tX2ZpbGUoICRpbXBvcnRidWRkeV9maWxlICk7CmlmICggJycgPT0gJGltcG9ydEZpbGVTZXJpYWwgKSB7CglkaWUoICdBY2Nlc3MgZGVuaWVkLicgKTsKfQoKcGJfYmFja3VwYnVkZHk6OnN0YXR1cyggJ2RldGFpbHMnLCAnKioqIEVuZCBJbXBvcnRCdWRkeSBMb2cgU2VjdGlvbiAoRGVwbG95bWVudCknICk7CgovLyBMb2cgdG8gbWFrZSBhIGNvcHkgb2YgcmV0cmlldmVkIGRlcGxveSBpbmZvIGludG8uCiRsb2dfZGlyZWN0b3J5ID0gYmFja3VwYnVkZHlfY29yZTo6Z2V0TG9nRGlyZWN0b3J5KCk7CiRiYWNrdXBfbG9nX2ZpbGUgPSAkbG9nX2RpcmVjdG9yeSAuICdzdGF0dXMtZGVwbG95Y29weS0nIC4gJGltcG9ydEZpbGVTZXJpYWwgLiAnLnR4dCc7Cgokc3RhdHVzX2xpbmVzID0gcGJfYmFja3VwYnVkZHk6OmdldF9zdGF0dXMoICcnLCB0cnVlLCBmYWxzZSwgdHJ1ZSwgJGJhY2t1cF9sb2dfZmlsZSApOyAvLyBDbGVhciBmaWxlLCBkb250IHVubGluayBmaWxlLCBzdXByZXNzIHN0YXR1cyByZXRyaWV2YWwgbXNnLCBiYWNrdXAgaW50byAkbG9nX2ZpbGUKZWNobyBpbXBsb2RlKCAnJywgJHN0YXR1c19saW5lcyApOwo=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/getDeployLog.php,importbuddy/controllers/ajax/getDeployLog.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/hash_forgotpass.php,importbuddy/controllers/ajax/hash_forgotpass.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CgppZiAoICcnID09IHBiX2JhY2t1cGJ1ZGR5OjpfUE9TVCggJ25ld3Bhc3N3b3JkJyApICkgewoJZGllKCAnRXJyb3IgIzg0OTM0ODk6IE1pc3NpbmcgcGFzc3dvcmQuJyApOwp9CgpkaWUoIG1kNSggcGJfYmFja3VwYnVkZHk6Ol9QT1NUKCAnbmV3cGFzc3dvcmQnICkgKSApOw==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/hash_forgotpass.php,importbuddy/controllers/ajax/hash_forgotpass.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/index.php,importbuddy/controllers/ajax/index.php
PD9waHAgLy8gU2lsZW5jZSBpcyBnb2xkZW4u
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/index.php,importbuddy/controllers/ajax/index.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/mysql_test.php,importbuddy/controllers/ajax/mysql_test.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CkF1dGg6OnJlcXVpcmVfYXV0aGVudGljYXRpb24oKTsgLy8gRGllIGlmIG5vdCBsb2dnZWQgaW4uCgovLyBJbmNsdWRlIHRoZSBEQiBUZXN0cyBjbGFzcyBhbmQgaW5pdCBpdC4KcmVxdWlyZV9vbmNlKCBBQlNQQVRIIC4gJ2ltcG9ydGJ1ZGR5L2NsYXNzZXMvdGVzdC1kYi5waHAnICk7CiRpbXBvcnRidWRkeV90ZXN0X2RiID0gbmV3IGltcG9ydGJ1ZGR5X3Rlc3RfZGIoKTsK
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/mysql_test.php,importbuddy/controllers/ajax/mysql_test.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/create_admin.php,importbuddy/controllers/pages/create_admin.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/create_admin.php,importbuddy/controllers/pages/create_admin.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/dbreplace.php,importbuddy/controllers/pages/dbreplace.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CkF1dGg6OnJlcXVpcmVfYXV0aGVudGljYXRpb24oKTsgLy8gRGllIGlmIG5vdCBsb2dnZWQgaW4uCgoKJGRhdGEgPSBhcnJheSgpOwpwYl9iYWNrdXBidWRkeTo6bG9hZF92aWV3KCAnZGJyZXBsYWNlJywgJGRhdGEgKTsKPz48c2NyaXB0PmpRdWVyeSggJyNwYWdlVGl0bGUnICkuaHRtbCggJ0RhdGFiYXNlIFRleHQgUmVwbGFjZScgKTs8L3NjcmlwdD4=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/dbreplace.php,importbuddy/controllers/pages/dbreplace.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/default.php,importbuddy/controllers/pages/default.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/default.php,importbuddy/controllers/pages/default.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/diagnostics.php,importbuddy/controllers/pages/diagnostics.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/diagnostics.php,importbuddy/controllers/pages/diagnostics.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/homeBackupSelect.php,importbuddy/controllers/pages/homeBackupSelect.php
PD9waHAKLyoqCiAqIEhvbWUgQmFja3VwIFNlbGVjdCBWaWV3IEZpbGUuCiAqCiAqIEBwYWNrYWdlIEJhY2t1cEJ1ZGR5CiAqLwoKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CgovLyBPbiBpbml0aWFsIGxvZ2luIHRvIFN0ZXAgMSAoY2hlY2tzIGZvciBwYXNzd29yZCBmaWVsZCBmcm9tIGF1dGggZm9ybSkgcmVzZXQgYW55IGRhbmdsaW5nIGRlZmF1bHRzIGZyb20gYSBwYXJ0aWFsIHJlc3RvcmUuCmlmICggKCB0cnVlID09PSBBdXRoOjppc19hdXRoZW50aWNhdGVkKCkgKSAmJiAoIHBiX2JhY2t1cGJ1ZGR5OjpfUE9TVCggJ3Bhc3N3b3JkJyApICE9ICcnICkgKSB7CglwYl9iYWNrdXBidWRkeTo6cmVzZXRfZGVmYXVsdHMoKTsKfQoKLy8gSGFuZGxlIHNtYWxsIHNpemUgUEhQIHVwbG9hZCBsaW1pdCBrbm9ja2luZyBvZmYgYXV0aGVudGljYXRpb24gd2hlbiB1cGxvYWRpbmcgYSBiYWNrdXAuCmlmICggaXNzZXQoICRfU0VSVkVSWydDT05URU5UX0xFTkdUSCddICkgJiYgKCBpbnR2YWwoICRfU0VSVkVSWydDT05URU5UX0xFTkdUSCddICkgPiAwICkgJiYgKCBjb3VudCggJF9QT1NUICkgPT09IDAgKSApIHsKCXBiX2JhY2t1cGJ1ZGR5OjphbGVydCggJ0Vycm9yICM1NDg0NTQ4NTk1LiBVbmFibGUgdG8gdXBsb2FkLiBZb3VyIFBIUCBwb3N0X21heF9zaXplIHNldHRpbmcgaXMgdG9vIHNtYWxsIHNvIGl0IGRpc2NhcmRlZCBQT1NUIGRhdGEuIFlvdSBtYXkgaGF2ZSB0byBsb2cgYmFjayBpbi4nLCB0cnVlICk7Cn0KdXBsb2FkKCk7IC8vIEhhbmRsZSBhbnkgdXBsb2FkaW5nIG9mIGEgYmFja3VwIGZpbGUuCgokZGF0YSA9IGFycmF5KCk7CgovKioKICogUHJvY2Vzc2VzIHVwbG9hZGVkIGJhY2t1cCBmaWxlLgogKgogKiBAcmV0dXJuIGFycmF5ICBUcnVlIG9uIHVwbG9hZCBzdWNjZXNzOyBmYWxzZSBvdGhlcndpc2UuCiAqLwpmdW5jdGlvbiB1cGxvYWQoKSB7CgoJQXV0aDo6cmVxdWlyZV9hdXRoZW50aWNhdGlvbigpOwoKCWlmICggaXNzZXQoICRfUE9TVFsndXBsb2FkJ10gKSAmJiAoICRfUE9TVFsndXBsb2FkJ10gPT0gJ2xvY2FsJyApICkgewoJCSRwYXRoX3BhcnRzID0gcGF0aGluZm8oICRfRklMRVNbJ2ZpbGUnXVsnbmFtZSddICk7CgkJaWYgKCAoIHN0cnRvbG93ZXIoIHN1YnN0ciggJF9GSUxFU1snZmlsZSddWyduYW1lJ10sIDAsIDYgKSApID09ICdiYWNrdXAnICkgJiYgKCBzdHJ0b2xvd2VyKCAkcGF0aF9wYXJ0c1snZXh0ZW5zaW9uJ10gKSA9PSAnemlwJyApICkgewoJCQlpZiAoIG1vdmVfdXBsb2FkZWRfZmlsZSggJF9GSUxFU1snZmlsZSddWyd0bXBfbmFtZSddLCBiYXNlbmFtZSggJF9GSUxFU1snZmlsZSddWyduYW1lJ10gKSApICkgewoJCQkJcGJfYmFja3VwYnVkZHk6OmFsZXJ0KCAnRmlsZSBVcGxvYWRlZC4gWW91ciBiYWNrdXAgd2FzIHN1Y2Nlc3NmdWxseSB1cGxvYWRlZC4nICk7CgkJCQlyZXR1cm4gdHJ1ZTsKCQkJfSBlbHNlIHsKCQkJCXBiX2JhY2t1cGJ1ZGR5OjphbGVydCggJ1NvcnJ5LCB0aGVyZSB3YXMgYSBwcm9ibGVtIHVwbG9hZGluZyB5b3VyIGZpbGUuJywgdHJ1ZSApOwoJCQkJcmV0dXJuIGZhbHNlOwoJCQl9CgkJfSBlbHNlIHsKCQkJcGJfYmFja3VwYnVkZHk6OmFsZXJ0KCAnT25seSBwcm9wZXJseSBuYW1lZCBCYWNrdXBCdWRkeSB6aXAgYXJjaGl2ZXMgd2l0aCBhIHppcCBleHRlbnNpb24gbWF5IGJlIHVwbG9hZGVkLicsIHRydWUgKTsKCQkJcmV0dXJuIGZhbHNlOwoJCX0KCX0KCgkvLyBET1dOTE9BRCBGSUxFIEZST00gU1RBU0ggVE8gTE9DQUwuCglpZiAoIHBiX2JhY2t1cGJ1ZGR5OjpfUE9TVCggJ3VwbG9hZCcgKSA9PSAnc3Rhc2gnICkgewoKCQlwYl9iYWNrdXBidWRkeTo6c2V0X2dyZWVkeV9zY3JpcHRfbGltaXRzKCB0cnVlICk7CgoJCSRyZXF1ZXN0Y29yZV9maWxlID0gZGlybmFtZSggZGlybmFtZSggZGlybmFtZSggX19GSUxFX18gKSApICkgLiAnL2xpYi9yZXF1ZXN0Y29yZS9yZXF1ZXN0Y29yZS5jbGFzcy5waHAnOwoJCXJlcXVpcmVfb25jZSAkcmVxdWVzdGNvcmVfZmlsZTsKCgkJJGxpbmsgICAgICAgICAgICAgPSBwYl9iYWNrdXBidWRkeTo6X1BPU1QoICdsaW5rJyApOwoJCSRkZXN0aW5hdGlvbl9maWxlID0gZGlybmFtZSggZGlybmFtZSggZGlybmFtZSggZGlybmFtZSggX19GSUxFX18gKSApICkgKSAuICcvJyAuIGJhc2VuYW1lKCBwYl9iYWNrdXBidWRkeTo6X1BPU1QoICdsaW5rJyApICk7CgkJJGRlc3RpbmF0aW9uX2ZpbGUgPSBzdWJzdHIoICRkZXN0aW5hdGlvbl9maWxlLCAwLCBzdHJpcG9zKCAkZGVzdGluYXRpb25fZmlsZSwgJy56aXAnICkgKyA0ICk7CgoJCSRfR0VUWydmaWxlJ10gPSBiYXNlbmFtZSggJGRlc3RpbmF0aW9uX2ZpbGUgKTsKCgkJJHJlcXVlc3QgPSBuZXcgUmVxdWVzdENvcmUoICRsaW5rICk7CgkJJHJlcXVlc3QtPnNldF93cml0ZV9maWxlKCAkZGVzdGluYXRpb25fZmlsZSApOwoKCQllY2hvICc8ZGl2IGlkPSJwYl9pbXBvcnRidWRkeV93b3JraW5nIiBzdHlsZT0icGFkZGluZzogMjBweDsiPkRvd25sb2FkaW5nIGJhY2t1cCBmcm9tIFN0YXNoIHRvIGAnIC4gJGRlc3RpbmF0aW9uX2ZpbGUgLiAnYC4uLjxicj48YnI+PGltZyBzcmM9IicgLiBwYl9iYWNrdXBidWRkeTo6cGx1Z2luX3VybCgpIC4gJy9pbWFnZXMvbG9hZGluZ19sYXJnZS5naWYiIHRpdGxlPSJXb3JraW5nLi4uIFBsZWFzZSB3YWl0IGFzIHRoaXMgbWF5IHRha2UgYSBtb21lbnQuLi4iPjxicj48YnI+PC9kaXY+JzsKCQlwYl9iYWNrdXBidWRkeTo6Zmx1c2goKTsKCgkJJHJlc3BvbnNlID0gJHJlcXVlc3QtPnNlbmRfcmVxdWVzdCggZmFsc2UgKTsKCQlpZiAoICRyZXNwb25zZSAhPT0gdHJ1ZSApIHsKCQkJcGJfYmFja3VwYnVkZHk6OmFsZXJ0KCAnRXJyb3IgIzg1NDg0NTk1OTguIFVuYWJsZSB0byBkb3dubG9hZCBmaWxlIGZyb20gU3Rhc2guIFlvdSBtYXkgbWFudWFsbHkgZG93bmxvYWQgaXQgYW5kIHVwbG9hZCB0byB0aGUgc2VydmVyIHZpYSBGVFAuJyApOwoJCX0gZWxzZSB7IC8vIE5vIGVycm9yLgoJCQlpZiAoICEgZmlsZV9leGlzdHMoICRkZXN0aW5hdGlvbl9maWxlICkgKSB7CgkJCQlwYl9iYWNrdXBidWRkeTo6YWxlcnQoICdFcnJvciAjMzQ4NDU3NDU4NzguIFN0YXNoIHJldHVybmVkIGEgc3VjY2VzcyBidXQgdGhlIGJhY2t1cCBmaWxlIHdhcyBub3QgZm91bmQgbG9jYWxseS4gQ2hlY2sgdGhpcyBzZXJ2ZXJcJ3MgZGlyZWN0b3J5IHdyaXRlIHBlcm1pc3Npb25zLiBZb3UgbWF5IG1hbnVhbGx5IGRvd25sb2FkIGl0IGFuZCB1cGxvYWQgdG8gdGhlIHNlcnZlciB2aWEgRlRQLicgKTsKCQkJfQoJCX0KCgkJZWNobyAnPHNjcmlwdCB0eXBlPSJ0ZXh0L2phdmFzY3JpcHQiPmpRdWVyeSgiI3BiX2ltcG9ydGJ1ZGR5X3dvcmtpbmciKS5oaWRlKCk7PC9zY3JpcHQ+JzsKCgl9Cn0KCi8qKgogKiBSZXR1cm5zIGFuIGFycmF5IG9mIGJhY2t1cCBhcmNoaXZlIHppcCBmaWxlbmFtZXMgZm91bmQuCiAqCiAqIEByZXR1cm4gYXJyYXkgIEFycmF5IG9mIC56aXAgZmlsZW5hbWVzOyBwYXRoIE5PVCBpbmNsdWRlZC4KICovCmZ1bmN0aW9uIGdldF9hcmNoaXZlc19saXN0KCkgewoKCUF1dGg6OnJlcXVpcmVfYXV0aGVudGljYXRpb24oKTsKCglpZiAoICEgaXNzZXQoIHBiX2JhY2t1cGJ1ZGR5OjokY2xhc3Nlc1snemlwYnVkZHknXSApICkgewoJCXJlcXVpcmVfb25jZSBwYl9iYWNrdXBidWRkeTo6cGx1Z2luX3BhdGgoKSAuICcvbGliL3ppcGJ1ZGR5L3ppcGJ1ZGR5LnBocCc7CgkJcGJfYmFja3VwYnVkZHk6OiRjbGFzc2VzWyd6aXBidWRkeSddID0gbmV3IHBsdWdpbmJ1ZGR5X3ppcGJ1ZGR5KCBBQlNQQVRIICk7Cgl9CgoJLy8gTGlzdCBiYWNrdXAgZmlsZXMgaW4gdGhpcyBkaXJlY3RvcnkuCgkkYmFja3VwX2FyY2hpdmVzID0gYXJyYXkoKTsKCSRiYWNrdXBfemlwcyAgICAgPSBnbG9iKCBBQlNQQVRIIC4gJ2JhY2t1cCouemlwJyApOwoJaWYgKCAhIGlzX2FycmF5KCAkYmFja3VwX3ppcHMgKSApIHsKCQkkYmFja3VwX3ppcHMgPSBhcnJheSgpOwoJfQoJJHNuYXBzaG90X3ppcHMgPSBnbG9iKCBBQlNQQVRIIC4gJ3NuYXBzaG90Ki56aXAnICk7CglpZiAoICEgaXNfYXJyYXkoICRzbmFwc2hvdF96aXBzICkgKSB7CgkJJHNuYXBzaG90X3ppcHMgPSBhcnJheSgpOwoJfQoJJGJhY2t1cF9hcmNoaXZlc19nbG9iID0gYXJyYXlfbWVyZ2UoICRiYWNrdXBfemlwcywgJHNuYXBzaG90X3ppcHMgKTsKCXVuc2V0KCAkYmFja3VwX3ppcHMgKTsKCXVuc2V0KCAkc25hcHNob3RfemlwcyApOwoJZm9yZWFjaCAoICRiYWNrdXBfYXJjaGl2ZXNfZ2xvYiBhcyAkYmFja3VwX2FyY2hpdmUgKSB7CgkJJGNvbW1lbnQgPSBwYl9iYWNrdXBidWRkeTo6JGNsYXNzZXNbJ3ppcGJ1ZGR5J10tPmdldF9jb21tZW50KCAkYmFja3VwX2FyY2hpdmUgKTsKCQkkY29tbWVudCA9IGJhY2t1cGJ1ZGR5X2NvcmU6Om5vcm1hbGl6ZV9jb21tZW50X2RhdGEoICRjb21tZW50ICk7CgoJCSR0aGlzX2FyY2hpdmUgICAgICA9IGFycmF5KAoJCQknZmlsZScgICAgPT4gYmFzZW5hbWUoICRiYWNrdXBfYXJjaGl2ZSApLAoJCQknY29tbWVudCcgPT4gJGNvbW1lbnQsCgkJKTsKCQkkYmFja3VwX2FyY2hpdmVzW10gPSAkdGhpc19hcmNoaXZlOwoJfQoJdW5zZXQoICRiYWNrdXBfYXJjaGl2ZXNfZ2xvYiApOwoKCXJldHVybiAkYmFja3VwX2FyY2hpdmVzOwp9CgovKioKICogQ2hlY2tzIGZvciBwb3RlbnRpYWwgcHJvYmxlbXMgYmVmb3JlIGdldHRpbmcgc3RhcnRlZC4KICoKICogQHJldHVybiBhcnJheSAgUG90ZW50aWFsIHByb2JsZW1zLiBLZXkgaXMgYSB1bmlxdWUgc2x1ZyB0byB0aGUgaXNzdWUsIHZhbHVlIGlzIGEgZGVzY3JpcHRpdmUgdGV4dC4KICovCmZ1bmN0aW9uIHByZWZsaWdodFNjYW4oKSB7CgkkaXNzdWVzID0gYXJyYXkoKTsKCglpZiAoIGZpbGVfZXhpc3RzKCBBQlNQQVRIIC4gJ3dwLWNvbmZpZy5waHAnICkgKSB7CgkJJGlzc3Vlc1snd29yZHByZXNzX2V4aXN0cyddID0gJ1dBUk5JTkc6IEV4aXN0aW5nIFdvcmRQcmVzcyBpbnN0YWxsYXRpb24gZm91bmQuIEl0IGlzIHN0cm9uZ2x5IHJlY29tbWVuZGVkIHRoYXQgZXhpc3RpbmcgV29yZFByZXNzIGZpbGVzIGFuZCBkYXRhYmFzZSBiZSByZW1vdmVkIHByaW9yIHRvIG1pZ3JhdGluZyBvciByZXN0b3JpbmcgdG8gYXZvaWQgY29uZmxpY3RzLiBZb3Ugc2hvdWxkIG5vdCBpbnN0YWxsIFdvcmRQcmVzcyBwcmlvciB0byBtaWdyYXRpbmcuJzsKCX0KCglpZiAoIGZpbGVfZXhpc3RzKCBBQlNQQVRIIC4gJ3BocC5pbmknICkgKSB7CgkJJGlzc3Vlc1sncGhwX2luaV9leGlzdHMnXSA9ICdXQVJOSU5HOiBFeGlzdGluZyBwaHAuaW5pIGZpbGUgZm91bmQgd2hpY2ggY29uZmlndXJlcyBjdXN0b20gUEhQIHNldHRpbmdzLiBJZiB5b3VyIGJhY2t1cCBhbHNvIGNvbnRhaW5zIGEgcGhwLmluaSBmaWxlIGl0IG1heSBvdmVyd3JpdGUgdGhlIGN1cnJlbnQgb25lLCBwb3NzaWJseSByZXN1bHRpbmcgaW4gY2hhbmdlcyBpbiBjb25maWd1cmF0aW9uIG9yIHByb2JsZW1zLiBNYWtlIGEgYmFja3VwIG9mIHlvdXIgZXhpc3RpbmcgZmlsZSBpZiB5b3VyIGFyZSB1bnN1cmUuJzsKCX0KCglpZiAoIGZpbGVfZXhpc3RzKCBBQlNQQVRIIC4gJy51c2VyLmluaScgKSApIHsKCQkkaXNzdWVzWydwaHBfaW5pX2V4aXN0cyddID0gJ1dBUk5JTkc6IEV4aXN0aW5nIC51c2VyLmluaSBmaWxlIGZvdW5kIHdoaWNoIGNvbmZpZ3VyZXMgY3VzdG9tIFBIUCBzZXR0aW5ncy4gSWYgeW91ciBiYWNrdXAgYWxzbyBjb250YWlucyBhIC51c2VyLmluaSBmaWxlIGl0IG1heSBvdmVyd3JpdGUgdGhlIGN1cnJlbnQgb25lLCBwb3NzaWJseSByZXN1bHRpbmcgaW4gY2hhbmdlcyBpbiBjb25maWd1cmF0aW9uIG9yIHByb2JsZW1zLiBNYWtlIGEgYmFja3VwIG9mIHlvdXIgZXhpc3RpbmcgZmlsZSBpZiB5b3VyIGFyZSB1bnN1cmUuJzsKCX0KCglpZiAoIGZpbGVfZXhpc3RzKCBBQlNQQVRIIC4gJy5odGFjY2VzcycgKSApIHsKCQkkaXNzdWVzWydodGFjY2Vzc19leGlzdHMnXSA9ICdXQVJOSU5HOiBFeGlzdGluZyAuaHRhY2Nlc3MgZmlsZSBmb3VuZC4gSWYgeW91ciBiYWNrdXAgYWxzbyBjb250YWlucyBhIC5odGFjY2VzcyBmaWxlIGl0IG1heSBvdmVyd3JpdGUgdGhlIGN1cnJlbnQgb25lLCBwb3NzaWJseSByZXN1bHRpbmcgaW4gY2hhbmdlcyBpbiBjb25maWd1cmF0aW9uIG9yIHByb2JsZW1zLiBNYWtlIGEgYmFja3VwIG9mIHlvdXIgZXhpc3RpbmcgZmlsZSBpZiB5b3UgYXJlIHVuc3VyZS4nOwoJfQoKCS8qCgkgVE9ETzogTW92ZSB0byBwb3N0IGZsaWdodCBzY2FuLgoJaWYgKCAoIGZpbGVfZXhpc3RzKCBBQlNQQVRIIC4gJ2luZGV4Lmh0bScgKSA9PT0gdHJ1ZSApIHx8ICggZmlsZV9leGlzdHMoIEFCU1BBVEggLiAnaW5kZXguaHRtbCcgKSA9PT0gdHJ1ZSApICkgewoJCSRpc3N1ZXNbJ2luZGV4X2V4aXN0cyddID0gJ0FuIGluZGV4Lmh0bShsKSBmaWxlIGV4aXN0cyBpbiB0aGlzIHNpdGUgcGF0aC4gRGVwZW5kaW5nIG9uIHlvdXIgc2VydmVyIHNldHVwIGl0IG1heSB0YWtlIHByZWNlZGVuY2UgaW4gbG9hZGluZyBpbnN0ZWFkIG9mIFdvcmRQcmVzcy4gSWYgYWZ0ZXIgcmVzdG9yZSB5b3VyIHNpdGUgbG9hZHMgYW4gdW5leHBlY3RlZCBvciBibGFuayBwYWdlLCB0cnkgcmVuYW1pbmcgb3IgZGVsZXRpbmcgdGhlIGluZGV4Lmh0bShsKSBmaWxlKHMpIGluIHRoZSBzaXRlIHJvb3QsIGAnIC4gQUJTUEFUSCAuICdgLic7Cgl9CgkqLwoKCS8vIExvb2sgZm9yIGRpcmVjdG9yaWVzIG5hbWVkIGFmdGVyIGEgYmFja3VwIGZpbGUgdGhhdCBjb250YWluIFdvcmRQcmVzcy4gLS0gaW1wcm9wZXJseSB1bnppcHBlZCBpbiB0aGUgd3JvbmcgbG9jYXRpb24uCgkkYmFja3VwX2RpcnMgPSBnbG9iKCBBQlNQQVRIIC4gJ2JhY2t1cC0qL3dwLWxvZ2luLnBocCcgKTsKCWlmICggISBpc19hcnJheSggJGJhY2t1cF9kaXJzICkgKSB7CgkJJGJhY2t1cF9kaXJzID0gYXJyYXkoKTsKCX0KCWlmICggY291bnQoIChhcnJheSkgJGJhY2t1cF9kaXJzICkgPiAwICkgewoJCSRpc3N1ZXNbJ21hbnVhbF91bnppcF93cm9uZ19sb2NhdGlvbiddID0gJ0EgbWFudWFsbHkgdW56aXBwZWQgYmFja3VwIG1heSBoYXZlIGJlZW4gZm91bmQgaW4gdGhlIGZvbGxvd2luZyBsb2NhdGlvbihzKS4gSWYgeW91IG1hbnVhbGx5IHVuemlwcGVkIGNvbmZpcm0gdGhlIGZpbGVzIHdlcmUgbm90IHVuemlwcGVkIGludG8gdGhpcyBzdWJkaXJlY3RvcnkgZWxzZSB0aGV5IHdpbGwgbmVlZCB0byBiZSBtb3ZlZCB1cCBvdXQgb2YgdGhlIHN1YmRpcmVjdG9yeSBpbnRvIHRoZSBzYW1lIGRpcmVjdG9yeSBhcyBpbXBvcnRidWRkeS5waHAuIFBvc3NpYmxlIG1hbnVhbGx5IHVuemlwcGVkIGJhY2t1cHMgaW4gYSBzdWJkaXJlY3Rvcnk6ICcgLiBpbXBsb2RlKCAnLCAnLCAkYmFja3VwX2RpcnMgKTsKCX0KCglyZXR1cm4gJGlzc3VlczsKfQoKCgpwYl9iYWNrdXBidWRkeTo6bG9hZF92aWV3KCAnaG9tZScsICRkYXRhICk7CgovLyBMT0cgSU1QT1JUQlVERFkgVkVSU0lPTiBJTkZPUk1BVElPTi4KcGJfYmFja3VwYnVkZHk6OnN0YXR1cyggJ2RldGFpbHMnLCAnUnVubmluZyBJbXBvcnRCdWRkeSB2JyAuIHBiX2JhY2t1cGJ1ZGR5Ojokb3B0aW9uc1snYmJfdmVyc2lvbiddIC4gJy4nICk7Cg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/homeBackupSelect.php,importbuddy/controllers/pages/homeBackupSelect.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/index.php,importbuddy/controllers/pages/index.php
PD9waHAgLy8gU2lsZW5jZSBpcyBnb2xkZW4u
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/index.php,importbuddy/controllers/pages/index.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/login.php,importbuddy/controllers/pages/login.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/login.php,importbuddy/controllers/pages/login.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/serverinfo.php,importbuddy/controllers/pages/serverinfo.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CkF1dGg6OnJlcXVpcmVfYXV0aGVudGljYXRpb24oKTsgLy8gRGllIGlmIG5vdCBsb2dnZWQgaW4uCgpyZXF1aXJlX29uY2UoIEFCU1BBVEggLidpbXBvcnRidWRkeS92aWV3cy9faGVhZGVyLnBocCcgKTsKPz4KPHNjcmlwdD5qUXVlcnkoICcjcGFnZVRpdGxlJyApLmh0bWwoICdTZXJ2ZXIgSW5mb3JtYXRpb24nICk7PC9zY3JpcHQ+Cgo8ZGl2IGNsYXNzPSJ3cmFwIj4KCTw/cGhwCglnbG9iYWwgJGRldGVjdGVkX21heF9leGVjdXRpb25fdGltZTsKCXJlcXVpcmVfb25jZSggJ2RpYWdub3N0aWNzLnBocCcgKTsKCT8+CjwvZGl2PgoKPD9waHAKcmVxdWlyZV9vbmNlKCBBQlNQQVRIIC4naW1wb3J0YnVkZHkvdmlld3MvX2Zvb3Rlci5waHAnICk7
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/serverinfo.php,importbuddy/controllers/pages/serverinfo.php
###PACKDATA,FILE_START,/classes/_migrate_database.php,importbuddy/classes/_migrate_database.php
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
###PACKDATA,FILE_END,/classes/_migrate_database.php,importbuddy/classes/_migrate_database.php
###PACKDATA,FILE_START,/classes/core.php,importbuddy/classes/core.php
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
###PACKDATA,FILE_END,/classes/core.php,importbuddy/classes/core.php
###PACKDATA,FILE_START,/classes/import.php,importbuddy/classes/import.php
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
###PACKDATA,FILE_END,/classes/import.php,importbuddy/classes/import.php
###PACKDATA,FILE_START,/classes/restore.php,importbuddy/classes/restore.php
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